package com.cv.media.lib.api;

import com.cv.media.lib.common_utils.obfuscation.KeepClassMember;
import com.cv.media.lib.common_utils.pool.ObjectPool;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.List;

import okhttp3.Call;
import okhttp3.Connection;
import okhttp3.Handshake;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;

/**
* 描述一个具体主机请求
* 职责:
* @author Damon
*/
public class NW_HostNode extends NW_Base implements KeepClassMember {
    private String host;
    private List<NW_IPPNode> connections = new ArrayList<>();
    private transient NW_IPPNode currentConnectionEvent;

    public NW_HostNode() {
        reset();
    }

    @Override
    void reset() {
        host = null;
        connections.clear();
        currentConnectionEvent = null;
    }

    public void setHost(String host) {
        this.host = host;
    }

    @Override
    public void callStart(Call call) {
    }

    public void dnsStart(Call call, String domainName) {
        currentConnectionEvent = ObjectPool.obtain(NW_IPPNode.class);
        currentConnectionEvent.setDes("new");
        connections.add(currentConnectionEvent);
        currentConnectionEvent.dnsStart(call, domainName);
    }

    public void dnsEnd(Call call, String domainName, List<InetAddress> inetAddressList) {
        if (currentConnectionEvent != null)
            currentConnectionEvent.dnsEnd(call, domainName, inetAddressList);
    }

    public void connectStart(Call call, InetSocketAddress inetSocketAddress, Proxy proxy) {
        if (currentConnectionEvent != null)
            currentConnectionEvent.connectStart(call, inetSocketAddress, proxy);
    }

    public void secureConnectStart(Call call) {
        if (currentConnectionEvent != null) currentConnectionEvent.secureConnectStart(call);
    }

    public void secureConnectEnd(Call call, Handshake handshake) {
        if (currentConnectionEvent != null)
            currentConnectionEvent.secureConnectEnd(call, handshake);
    }

    public void connectEnd(Call call, InetSocketAddress inetSocketAddress, Proxy proxy,
                           Protocol protocol) {
        if (currentConnectionEvent != null)
            currentConnectionEvent.connectEnd(call, inetSocketAddress, proxy, protocol);
    }

    public void connectFailed(Call call, InetSocketAddress inetSocketAddress, Proxy proxy,
                              Protocol protocol, IOException ioe) {
        if (currentConnectionEvent != null)
            currentConnectionEvent.connectFailed(call, inetSocketAddress, proxy, protocol, ioe);
    }


    public void connectionAcquired(Call call, Connection connection) {
        if (currentConnectionEvent != null){
            currentConnectionEvent.connectionAcquired(call, connection);
        } else {
            currentConnectionEvent = ObjectPool.obtain(NW_IPPNode.class);
            currentConnectionEvent.setDes("old");
            currentConnectionEvent.connectionAcquired(call, connection);
            connections.add(currentConnectionEvent);
        }
    }


    public void connectionReleased(Call call, Connection connection) {
        if (currentConnectionEvent != null)
            currentConnectionEvent.connectionReleased(call, connection);
    }


    public void requestHeadersStart(Call call) {
        if (currentConnectionEvent != null) currentConnectionEvent.requestHeadersStart(call);
    }


    public void requestHeadersEnd(Call call, Request request) {
        if (currentConnectionEvent != null) currentConnectionEvent.requestHeadersEnd(call, request);
    }


    public void requestBodyStart(Call call) {
        if (currentConnectionEvent != null) currentConnectionEvent.requestBodyStart(call);
    }


    public void requestBodyEnd(Call call, long byteCount) {
        if (currentConnectionEvent != null) currentConnectionEvent.requestBodyEnd(call, byteCount);
    }


    public void responseHeadersStart(Call call) {
        if (currentConnectionEvent != null) currentConnectionEvent.responseHeadersStart(call);
    }


    public void responseHeadersEnd(Call call, Response response) {
        if (currentConnectionEvent != null)
            currentConnectionEvent.responseHeadersEnd(call, response);
    }


    public void responseBodyStart(Call call) {
        if (currentConnectionEvent != null) currentConnectionEvent.responseBodyStart(call);
    }


    public void responseBodyEnd(Call call, long byteCount) {
        if (currentConnectionEvent != null) currentConnectionEvent.responseBodyEnd(call, byteCount);
    }


    public void callEnd(Call call) {
        if (currentConnectionEvent != null) currentConnectionEvent.callEnd(call);
        currentConnectionEvent = null;
    }


    public void callFailed(Call call, IOException ioe) {
        if (currentConnectionEvent != null) currentConnectionEvent.callFailed(call, ioe);
        currentConnectionEvent = null;
    }


    @Override
    public void recycle() {
        for (NW_IPPNode connection : connections) {
            connection.recycle();
        }
        super.recycle();
    }
}
