package com.cv.media.lib.api;

import java.io.IOException;

import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

class InterceptorHead implements Interceptor {
    @Override
    public Response intercept(Chain chain) throws IOException {
        try {
            Request request = chain.request();
            NetWorksMonitor.getInstance().requestIn(request, chain.call());
            Response response = chain.proceed(request);
            NetWorksMonitor.getInstance().responseOut(response, chain.call());
            return response;
        } catch (Exception e) {
            //IOException Okhttp处理
            if (!(e instanceof  IOException))NetWorksMonitor.getInstance().interceptorException(chain.call(), e);
            throw e;
        }
    }
}
