package com.cv.media.lib.api;

import androidx.annotation.Nullable;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;

import okhttp3.Request;
import retrofit2.Call;
import retrofit2.CallAdapter;
import retrofit2.Callback;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;

class NetWorkMonitorCallAdapterFactory extends CallAdapter.Factory {
    RxJava2CallAdapterFactory rxJava2CallAdapterFactory = RxJava2CallAdapterFactory.create();

    @Nullable
    @Override
    public CallAdapter<?, ?> get(Type returnType, Annotation[] annotations, Retrofit retrofit) {
        CallAdapter<?, ?> callAdapter = rxJava2CallAdapterFactory.get(returnType, annotations, retrofit);
        if (callAdapter != null)
            return new NetWorkMonitorCallAdapter((CallAdapter<Object, Object>) callAdapter);
        return null;
    }

    private static class NetWorkMonitorCallAdapter implements CallAdapter<Object, Object> {
        CallAdapter<Object, Object> callAdapter;

        public NetWorkMonitorCallAdapter(CallAdapter<Object, Object> callAdapter) {
            this.callAdapter = callAdapter;
        }

        @Override
        public Type responseType() {
            return callAdapter.responseType();
        }

        @Override
        public Object adapt(Call<Object> call) {
            NetWorksMonitor.getInstance().callCreate(call.request());
            return callAdapter.adapt(new MonitorRetrofitCall(call));
        }
    }

    private static class MonitorRetrofitCall implements Call<Object> {
        Call<Object> originalCall;

        public MonitorRetrofitCall(Call<Object> originalCall) {
            this.originalCall = originalCall;
        }

        @Override
        public Response<Object> execute() throws IOException {
            return originalCall.execute();
        }

        @Override
        public void enqueue(Callback<Object> callback) {
            originalCall.enqueue(callback);
        }

        @Override
        public boolean isExecuted() {
            return originalCall.isExecuted();
        }

        @Override
        public void cancel() {
            originalCall.cancel();
        }

        @Override
        public boolean isCanceled() {
            return originalCall.isCanceled();
        }

        @Override
        public Call<Object> clone() {
            return originalCall;
        }

        @Override
        public Request request() {
            return originalCall.request();
        }
    }

}
