/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.android.arouter.compiler.processor;

import com.alibaba.android.arouter.compiler.entity.RouteDoc;
import com.alibaba.android.arouter.compiler.processor.BaseProcessor;
import com.alibaba.android.arouter.facade.annotation.Autowired;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.alibaba.android.arouter.facade.enums.RouteType;
import com.alibaba.android.arouter.facade.enums.TypeKind;
import com.alibaba.android.arouter.facade.model.RouteMeta;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.WildcardTypeName;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.tools.StandardLocation;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

@SupportedAnnotationTypes(value={"com.alibaba.android.arouter.facade.annotation.Route", "com.alibaba.android.arouter.facade.annotation.Autowired"})
public class RouteProcessor
extends BaseProcessor {
    private Map<String, Set<RouteMeta>> groupMap = new HashMap<String, Set<RouteMeta>>();
    private Map<String, String> rootMap = new TreeMap<String, String>();
    private TypeMirror iProvider = null;
    private Writer docWriter;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.iProvider = this.elementUtils.getTypeElement("com.alibaba.android.arouter.facade.template.IProvider").asType();
        this.logger.info(">>> RouteProcessor init. <<<");
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (CollectionUtils.isNotEmpty(annotations)) {
            if (this.generateDoc) {
                try {
                    this.docWriter = this.mFiler.createResource(StandardLocation.SOURCE_OUTPUT, "com.alibaba.android.arouter.docs", "arouter-map-of-" + this.moduleName + ".json", new Element[0]).openWriter();
                }
                catch (IOException e) {
                    this.logger.error("Create doc writer failed, because " + e.getMessage());
                }
            }
            Set<? extends Element> routeElements = roundEnv.getElementsAnnotatedWith(Route.class);
            try {
                this.logger.info(">>> Found routes, start... <<<");
                this.parseRoutes(routeElements);
            }
            catch (Exception e) {
                this.logger.error(e);
            }
            if (this.docWriter != null) {
                try {
                    this.docWriter.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return true;
        }
        return false;
    }

    private void parseRoutes(Set<? extends Element> routeElements) throws IOException {
        if (CollectionUtils.isNotEmpty(routeElements)) {
            this.logger.info(">>> Found routes, size is " + routeElements.size() + " <<<");
            this.rootMap.clear();
            TypeMirror type_Activity = this.elementUtils.getTypeElement("android.app.Activity").asType();
            TypeMirror type_Service = this.elementUtils.getTypeElement("android.app.Service").asType();
            TypeMirror fragmentTm = this.elementUtils.getTypeElement("android.app.Fragment").asType();
            TypeMirror fragmentTmV4 = this.elementUtils.getTypeElement("android.support.v4.app.Fragment").asType();
            TypeMirror fragmentTmX = this.elementUtils.getTypeElement("androidx.fragment.app.Fragment").asType();
            TypeElement type_IRouteGroup = this.elementUtils.getTypeElement("com.alibaba.android.arouter.facade.template.IRouteGroup");
            TypeElement type_IProviderGroup = this.elementUtils.getTypeElement("com.alibaba.android.arouter.facade.template.IProviderGroup");
            ClassName routeMetaCn = ClassName.get(RouteMeta.class);
            ClassName routeTypeCn = ClassName.get(RouteType.class);
            ParameterizedTypeName inputMapTypeOfRoot = ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{ClassName.get(String.class), ParameterizedTypeName.get((ClassName)ClassName.get(Class.class), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf((TypeName)ClassName.get((TypeElement)type_IRouteGroup))})});
            ParameterizedTypeName inputMapTypeOfGroup = ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{ClassName.get(String.class), ClassName.get(RouteMeta.class)});
            ParameterSpec rootParamSpec = ParameterSpec.builder((TypeName)inputMapTypeOfRoot, (String)"routes", (Modifier[])new Modifier[0]).build();
            ParameterSpec groupParamSpec = ParameterSpec.builder((TypeName)inputMapTypeOfGroup, (String)"atlas", (Modifier[])new Modifier[0]).build();
            ParameterSpec providerParamSpec = ParameterSpec.builder((TypeName)inputMapTypeOfGroup, (String)"providers", (Modifier[])new Modifier[0]).build();
            MethodSpec.Builder loadIntoMethodOfRootBuilder = MethodSpec.methodBuilder((String)"loadInto").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(rootParamSpec);
            for (Element element : routeElements) {
                RouteMeta routeMeta;
                Iterator<Map.Entry<String, String>> tm = element.asType();
                Route route = element.getAnnotation(Route.class);
                if (this.types.isSubtype((TypeMirror)((Object)tm), type_Activity)) {
                    this.logger.info(">>> Found activity route: " + tm.toString() + " <<<");
                    HashMap<String, Integer> paramsType = new HashMap<String, Integer>();
                    HashMap<String, Autowired> injectConfig = new HashMap<String, Autowired>();
                    for (Element element2 : element.getEnclosedElements()) {
                        if (!element2.getKind().isField() || element2.getAnnotation(Autowired.class) == null || this.types.isSubtype(element2.asType(), this.iProvider)) continue;
                        Autowired paramConfig = element2.getAnnotation(Autowired.class);
                        String injectName = StringUtils.isEmpty((CharSequence)paramConfig.name()) ? element2.getSimpleName().toString() : paramConfig.name();
                        paramsType.put(injectName, this.typeUtils.typeExchange(element2));
                        injectConfig.put(injectName, paramConfig);
                    }
                    routeMeta = new RouteMeta(route, element, RouteType.ACTIVITY, paramsType);
                    routeMeta.setInjectConfig(injectConfig);
                } else if (this.types.isSubtype((TypeMirror)((Object)tm), this.iProvider)) {
                    this.logger.info(">>> Found provider route: " + tm.toString() + " <<<");
                    routeMeta = new RouteMeta(route, element, RouteType.PROVIDER, null);
                } else if (this.types.isSubtype((TypeMirror)((Object)tm), type_Service)) {
                    this.logger.info(">>> Found service route: " + tm.toString() + " <<<");
                    routeMeta = new RouteMeta(route, element, RouteType.parse((String)"android.app.Service"), null);
                } else if (this.types.isSubtype((TypeMirror)((Object)tm), fragmentTm) || this.types.isSubtype((TypeMirror)((Object)tm), fragmentTmV4) || this.types.isSubtype((TypeMirror)((Object)tm), fragmentTmX)) {
                    this.logger.info(">>> Found fragment route: " + tm.toString() + " <<<");
                    routeMeta = new RouteMeta(route, element, RouteType.parse((String)"android.app.Fragment"), null);
                } else {
                    throw new RuntimeException("ARouter::Compiler >>> Found unsupported class type, type = [" + this.types.toString() + "].");
                }
                this.categories(routeMeta);
            }
            MethodSpec.Builder loadIntoMethodOfProviderBuilder = MethodSpec.methodBuilder((String)"loadInto").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(providerParamSpec);
            HashMap hashMap = new HashMap();
            for (Map.Entry entry : this.groupMap.entrySet()) {
                String groupName = (String)entry.getKey();
                MethodSpec.Builder loadIntoMethodOfGroupBuilder = MethodSpec.methodBuilder((String)"loadInto").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(groupParamSpec);
                ArrayList<RouteDoc> routeDocList = new ArrayList<RouteDoc>();
                Set groupData = (Set)entry.getValue();
                for (RouteMeta routeMeta : groupData) {
                    RouteDoc routeDoc = this.extractDocInfo(routeMeta);
                    ClassName className = ClassName.get((TypeElement)((TypeElement)routeMeta.getRawType()));
                    switch (routeMeta.getType()) {
                        case PROVIDER: {
                            List<? extends TypeMirror> interfaces = ((TypeElement)routeMeta.getRawType()).getInterfaces();
                            for (TypeMirror typeMirror : interfaces) {
                                routeDoc.addPrototype(typeMirror.toString());
                                if (this.types.isSameType(typeMirror, this.iProvider)) {
                                    loadIntoMethodOfProviderBuilder.addStatement("providers.put($S, $T.build($T." + routeMeta.getType() + ", $T.class, $S, $S, null, " + routeMeta.getPriority() + ", " + routeMeta.getExtra() + "))", new Object[]{routeMeta.getRawType().toString(), routeMetaCn, routeTypeCn, className, routeMeta.getPath(), routeMeta.getGroup()});
                                    continue;
                                }
                                if (!this.types.isSubtype(typeMirror, this.iProvider)) continue;
                                loadIntoMethodOfProviderBuilder.addStatement("providers.put($S, $T.build($T." + routeMeta.getType() + ", $T.class, $S, $S, null, " + routeMeta.getPriority() + ", " + routeMeta.getExtra() + "))", new Object[]{typeMirror.toString(), routeMetaCn, routeTypeCn, className, routeMeta.getPath(), routeMeta.getGroup()});
                            }
                            break;
                        }
                    }
                    StringBuilder mapBodyBuilder = new StringBuilder();
                    Map paramsType = routeMeta.getParamsType();
                    Map map = routeMeta.getInjectConfig();
                    if (MapUtils.isNotEmpty((Map)paramsType)) {
                        ArrayList<RouteDoc.Param> paramList = new ArrayList<RouteDoc.Param>();
                        for (Map.Entry types : paramsType.entrySet()) {
                            mapBodyBuilder.append("put(\"").append((String)types.getKey()).append("\", ").append(types.getValue()).append("); ");
                            RouteDoc.Param param = new RouteDoc.Param();
                            Autowired injectConfig = (Autowired)map.get(types.getKey());
                            param.setKey((String)types.getKey());
                            param.setType(TypeKind.values()[(Integer)types.getValue()].name().toLowerCase());
                            param.setDescription(injectConfig.desc());
                            param.setRequired(injectConfig.required());
                            paramList.add(param);
                        }
                        routeDoc.setParams(paramList);
                    }
                    String mapBody = mapBodyBuilder.toString();
                    loadIntoMethodOfGroupBuilder.addStatement("atlas.put($S, $T.build($T." + routeMeta.getType() + ", $T.class, $S, $S, " + (StringUtils.isEmpty((CharSequence)mapBody) ? null : "new java.util.HashMap<String, Integer>(){{" + mapBodyBuilder.toString() + "}}") + ", " + routeMeta.getPriority() + ", " + routeMeta.getExtra() + "))", new Object[]{routeMeta.getPath(), routeMetaCn, routeTypeCn, className, routeMeta.getPath().toLowerCase(), routeMeta.getGroup().toLowerCase()});
                    routeDoc.setClassName(className.toString());
                    routeDocList.add(routeDoc);
                }
                String string = "ARouter_Group_" + groupName;
                JavaFile.builder((String)"com.alibaba.android.arouter.routes", (TypeSpec)TypeSpec.classBuilder((String)string).addJavadoc("DO NOT EDIT THIS FILE!!! IT WAS GENERATED BY AROUTER.", new Object[0]).addSuperinterface((TypeName)ClassName.get((TypeElement)type_IRouteGroup)).addModifiers(new Modifier[]{Modifier.PUBLIC}).addMethod(loadIntoMethodOfGroupBuilder.build()).build()).build().writeTo(this.mFiler);
                this.logger.info(">>> Generated group: " + groupName + "<<<");
                this.rootMap.put(groupName, string);
                hashMap.put(groupName, routeDocList);
            }
            if (MapUtils.isNotEmpty(this.rootMap)) {
                for (Map.Entry<String, String> entry : this.rootMap.entrySet()) {
                    loadIntoMethodOfRootBuilder.addStatement("routes.put($S, $T.class)", new Object[]{entry.getKey(), ClassName.get((String)"com.alibaba.android.arouter.routes", (String)entry.getValue(), (String[])new String[0])});
                }
            }
            if (this.generateDoc) {
                this.docWriter.append(JSON.toJSONString(hashMap, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
                this.docWriter.flush();
            }
            String providerMapFileName = "ARouter_Providers_" + this.moduleName;
            JavaFile.builder((String)"com.alibaba.android.arouter.routes", (TypeSpec)TypeSpec.classBuilder((String)providerMapFileName).addJavadoc("DO NOT EDIT THIS FILE!!! IT WAS GENERATED BY AROUTER.", new Object[0]).addSuperinterface((TypeName)ClassName.get((TypeElement)type_IProviderGroup)).addModifiers(new Modifier[]{Modifier.PUBLIC}).addMethod(loadIntoMethodOfProviderBuilder.build()).build()).build().writeTo(this.mFiler);
            this.logger.info(">>> Generated provider map, name is " + providerMapFileName + " <<<");
            String string = "ARouter_Root_" + this.moduleName;
            JavaFile.builder((String)"com.alibaba.android.arouter.routes", (TypeSpec)TypeSpec.classBuilder((String)string).addJavadoc("DO NOT EDIT THIS FILE!!! IT WAS GENERATED BY AROUTER.", new Object[0]).addSuperinterface((TypeName)ClassName.get((TypeElement)this.elementUtils.getTypeElement("com.alibaba.android.arouter.facade.template.IRouteRoot"))).addModifiers(new Modifier[]{Modifier.PUBLIC}).addMethod(loadIntoMethodOfRootBuilder.build()).build()).build().writeTo(this.mFiler);
            this.logger.info(">>> Generated root, name is " + string + " <<<");
        }
    }

    private RouteDoc extractDocInfo(RouteMeta routeMeta) {
        RouteDoc routeDoc = new RouteDoc();
        routeDoc.setGroup(routeMeta.getGroup());
        routeDoc.setPath(routeMeta.getPath());
        routeDoc.setDescription(routeMeta.getName());
        routeDoc.setType(routeMeta.getType().name().toLowerCase());
        routeDoc.setMark(routeMeta.getExtra());
        return routeDoc;
    }

    private void categories(RouteMeta routeMete) {
        if (this.routeVerify(routeMete)) {
            this.logger.info(">>> Start categories, group = " + routeMete.getGroup() + ", path = " + routeMete.getPath() + " <<<");
            Set<RouteMeta> routeMetas = this.groupMap.get(routeMete.getGroup());
            if (CollectionUtils.isEmpty(routeMetas)) {
                TreeSet<RouteMeta> routeMetaSet = new TreeSet<RouteMeta>(new Comparator<RouteMeta>(){

                    @Override
                    public int compare(RouteMeta r1, RouteMeta r2) {
                        try {
                            return r1.getPath().compareTo(r2.getPath());
                        }
                        catch (NullPointerException npe) {
                            RouteProcessor.this.logger.error(npe.getMessage());
                            return 0;
                        }
                    }
                });
                routeMetaSet.add(routeMete);
                this.groupMap.put(routeMete.getGroup(), routeMetaSet);
            } else {
                routeMetas.add(routeMete);
            }
        } else {
            this.logger.warning(">>> Route meta verify error, group is " + routeMete.getGroup() + " <<<");
        }
    }

    private boolean routeVerify(RouteMeta meta) {
        String path = meta.getPath();
        if (StringUtils.isEmpty((CharSequence)path) || !path.startsWith("/")) {
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)meta.getGroup())) {
            try {
                String defaultGroup = path.substring(1, path.indexOf("/", 1));
                if (StringUtils.isEmpty((CharSequence)defaultGroup)) {
                    return false;
                }
                meta.setGroup(defaultGroup);
                return true;
            }
            catch (Exception e) {
                this.logger.error("Failed to extract default group! " + e.getMessage());
                return false;
            }
        }
        return true;
    }
}

