/*
 * Decompiled with CFR 0.152.
 */
package com.vod.android.arouter.compiler.processor;

import com.vod.android.arouter.compiler.utils.Logger;
import com.vod.android.arouter.compiler.utils.TypeUtils;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class BaseProcessor
extends AbstractProcessor {
    Filer mFiler;
    Logger logger;
    Types types;
    Elements elementUtils;
    TypeUtils typeUtils;
    String moduleName = null;
    boolean generateDoc;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.mFiler = processingEnv.getFiler();
        this.types = processingEnv.getTypeUtils();
        this.elementUtils = processingEnv.getElementUtils();
        this.typeUtils = new TypeUtils(this.types, this.elementUtils);
        this.logger = new Logger(processingEnv.getMessager());
        Map<String, String> options = processingEnv.getOptions();
        if (MapUtils.isNotEmpty(options)) {
            this.moduleName = options.get("AROUTER_MODULE_NAME");
            this.generateDoc = "enable".equals(options.get("AROUTER_GENERATE_DOC"));
        }
        if (!StringUtils.isNotEmpty((CharSequence)this.moduleName)) {
            this.logger.error("These no module name, at 'build.gradle', like :\nandroid {\n    defaultConfig {\n        ...\n        javaCompileOptions {\n            annotationProcessorOptions {\n                arguments = [AROUTER_MODULE_NAME: project.getName()]\n            }\n        }\n    }\n}\n");
            throw new RuntimeException("ARouter::Compiler >>> No module name, for more information, look at gradle log.");
        }
        this.moduleName = this.moduleName.replaceAll("[^0-9a-zA-Z_]+", "");
        this.logger.info("The user has configuration the module name, it was [" + this.moduleName + "]");
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public Set<String> getSupportedOptions() {
        return new HashSet<String>(){
            {
                this.add("AROUTER_MODULE_NAME");
                this.add("AROUTER_GENERATE_DOC");
            }
        };
    }
}

