/*
 * Copyright 2018 firefly1126, Inc.

 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.gradle_plugin_android_aspectjx
 */
package com.hujiang.gradle.plugin.android.aspectjx

import com.android.build.gradle.AppPlugin
import com.android.build.gradle.BasePlugin
import com.android.build.gradle.LibraryPlugin
import com.android.build.gradle.api.BaseVariant
import org.gradle.api.DomainObjectCollection
import org.gradle.api.GradleException
import org.gradle.api.Project

/**
 * obtain information about the project configuration
 * @author simon
 * @version 1.0.0
 * @since 2016-04-20
 */
class AJXConfig {

    private final Project project
    private final boolean hasAppPlugin
    private final boolean hasLibPlugin
    private final def plugin

    AJXConfig(Project p) {
        project = p
        hasAppPlugin = project.plugins.hasPlugin(AppPlugin)
        def hasMainLibPlugin = project.plugins.hasPlugin("com.android.mainlibrary")
        hasLibPlugin = project.plugins.hasPlugin(LibraryPlugin) | hasMainLibPlugin
        if (!hasAppPlugin && !hasLibPlugin)throw new GradleException("android-aspjectjx: The 'com.android.application' or 'com.android.library' plugin is required.")
        plugin = project.plugins.getPlugin(hasAppPlugin ? AppPlugin : (hasMainLibPlugin ? "com.android.mainlibrary" : LibraryPlugin))
    }

    /**
     * Return all variants.
     *
     * @return Collection of variants.
     */
    DomainObjectCollection<BaseVariant> getVariants() {
        return hasAppPlugin ? project.android.applicationVariants : project.android.libraryVariants
    }

    /**
     * Return boot classpath.
     * @return Collection of classes.
     */
    List<File> getBootClasspath() {
        if (project.android.hasProperty('bootClasspath')) {
            return project.android.bootClasspath
        } else {
            return plugin.runtimeJarList
        }
    }
}