//
// Source code recreated from a .class file by IntelliJ IDEA
// (powered by Fernflower decompiler)
//

package com.cv.media.lib.common_utils.encrypt;

import org.bouncycastle.jce.provider.BouncyCastleProvider;

import java.security.Key;
import java.security.SecureRandom;
import java.security.Security;

import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class AESUtils {
    private static final String KEY_ALGORITHM = "AES";
    private static final int KEY_LNE = 128;

    public AESUtils() {
    }

    public static byte[] initkey(String keyString) throws Exception {
        KeyGenerator kg = KeyGenerator.getInstance("AES");
        SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
        secureRandom.setSeed(keyString.getBytes("UTF-8"));
        kg.init(128, secureRandom);
        SecretKey secretKey = kg.generateKey();
        return secretKey.getEncoded();
    }

    public static String generateKey(String keyString) {
        try {
            return Base64Utils.encodeURLSafe(initkey(keyString));
        } catch (Exception var2) {
            return "";
        }
    }

    public static byte[] decodeKey(String base64String) {
        return Base64Utils.decodeAsByteArray(base64String);
    }

    public static String hexKey(String keyString) {
        try {
            return ByteHexUtils.byte2hex(initkey(keyString), true);
        } catch (Exception var2) {
            return "";
        }
    }

    public static byte[] hex2ByteKey(String keyString) {
        try {
            return ByteHexUtils.hex2byte(keyString);
        } catch (Exception var2) {
            return new byte[0];
        }
    }

    public static Key codeToKey(String key) throws Exception {
        byte[] keyBytes = Base64Utils.decodeAsByteArray(key);
        SecretKey secretKey = new SecretKeySpec(keyBytes, "AES");
        return secretKey;
    }

    public static String decrypt(byte[] data, byte[] key) throws Exception {
        Key k = new SecretKeySpec(key, "AES");
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(2, k);
        return new String(cipher.doFinal(data), "UTF-8");
    }

    public static String decrypt(String data, String key) throws Exception {
        return decrypt(Base64Utils.decodeAsByteArray(data), Base64Utils.decodeAsByteArray(key));
    }

    public static byte[] encrypt(byte[] data, byte[] key) throws Exception {
        Key k = new SecretKeySpec(key, "AES");
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(1, k);
        return cipher.doFinal(data);
    }

    public static String encrypt(String data, String key) throws Exception {
        byte[] dataBytes = data.getBytes("UTF-8");
        byte[] keyBytes = Base64Utils.decodeAsByteArray(key);
        return Base64Utils.encodeURLSafe(encrypt(dataBytes, keyBytes));
    }

    public static String encrypt2Hex(String data, String key) throws Exception {
        byte[] dataBytes = data.getBytes("UTF-8");
        byte[] keyBytes = hex2ByteKey(key);
        return ByteHexUtils.byte2hex(encrypt(dataBytes, keyBytes), true);
    }

    public static String decryptHex(String data, String key) throws Exception {
        return decrypt(ByteHexUtils.hex2byte(data), ByteHexUtils.hex2byte(key));
    }

    public static String encrypt2(String data, String key) throws Exception {
        byte[] dataBytes = data.getBytes("UTF-8");
        byte[] keyBytes = initkey(key);
        return Base64Utils.encodeURLSafe(encrypt(dataBytes, keyBytes));
    }

    public static String decrypt2(String data, String key) throws Exception {
        byte[] dataBytes = Base64Utils.decodeAsByteArray(data);
        byte[] keyBytes = initkey(key);
        return decrypt(dataBytes, keyBytes);
    }

    static {
        Security.addProvider(new BouncyCastleProvider());
    }
}
