package com.cv.media.lib.common_utils.utils;

import org.apache.commons.io.FileUtils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class GZipUtils {
	// 压缩
	public static String compress(String str) throws IOException {
		if (str == null || str.length() == 0) {
			return str;
		}
		ByteArrayOutputStream out = new ByteArrayOutputStream();
		GZIPOutputStream gzip = new GZIPOutputStream(out);
		gzip.write(str.getBytes());
		gzip.close();
		return out.toString("ISO-8859-1");
	}

	// 解压缩
	public static String uncompress(String str) throws IOException {
		if (str == null || str.length() == 0) {
			return str;
		}
		ByteArrayOutputStream out = new ByteArrayOutputStream();
		ByteArrayInputStream in = new ByteArrayInputStream(str.getBytes("ISO-8859-1"));
		GZIPInputStream gunzip = new GZIPInputStream(in);
		byte[] buffer = new byte[256];
		int n;
		while ((n = gunzip.read(buffer)) >= 0) {
			out.write(buffer, 0, n);
		}
		str = out.toString();
		try{
            if (gunzip!=null){
                gunzip.close();
            }
			if (out!=null){
			    out.close();
            }
			if (in!=null){
			    in.close();
            }
		}catch (Exception e){

		}
		return str;
	}

	// 测试方法
	public static void main(String[] args) throws IOException {

		// 测试字符串
		String str = FileUtils.readFileToString(
				new File("C:\\Users\\ASUS\\Desktop\\9ef65174db9a3f22a26f1095dadc2822_1378610733_3_CF.mps"));

		System.out.println("原长度：" + str.length());

		System.out.println("压缩后：" + GZipUtils.compress(str).length());

		System.out.println("解压缩：" + GZipUtils.uncompress(GZipUtils.compress(str)).length());
	}
}
