package com.cv.media.lib.common_utils.appinit;

import java.io.PrintWriter;
import java.util.ArrayList;

/**
 * Task 基类
 * 职责:
 *
 * @author Damon
 */
abstract class InitTask{
    protected boolean inThread = false;
    protected Class tag;
    protected ArrayList<Class> dependencies = new ArrayList<>();
    protected int retryTimeValid;
    protected int level;
    protected int extraLevel;

    public int getLevel() {
        return level + extraLevel;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    int getRetryTime() {
        return 3;
    }

    protected final void setExtraLevel(int extraLevel) {
        this.extraLevel = extraLevel;
    }

    public int getExtraLevel() {
        return extraLevel;
    }

    protected InitTask() {
        retryTimeValid = getRetryTime();
    }

    public boolean isInThread() {
        return inThread;
    }

    String getTag() {
        return tag.getName();
    }

    public ArrayList<Class> getDependencies() {
        return dependencies;
    }

    /**
    *
     * @return  true 任务通过 false 任务不通过
    */
    public final boolean run() {
        try {
            boolean ref = proceed();
            if(ref) return true;
        }catch (Exception e){
            e.printStackTrace();
        }

        if ((--retryTimeValid) > 0) {
            return false;
        } else
            return true;
    }

    protected abstract boolean proceed() throws Exception;

    @Override
    public String toString() {
        return  getClass().getSimpleName() +"{" +
                "inThread=" + inThread +
                ", tag=" + tag +
                ", retryTimeValid=" + retryTimeValid +
                ", level =" + getLevel() +
                '}';
    }
}
