package com.cv.media.lib.common_utils.appinit;
import android.os.Handler;

import java.util.concurrent.Callable;

/**
* 场景任务
* 职责:
* @author Damon
*/
final class SituationTask extends InitTask implements IInitializationSituationTask{
    boolean needNetWork = false;
    boolean needAccount = false;
    long delayTime = 0;
    Callable<Boolean> task;

    public SituationTask() {
        super();
    }

    @Override
    int getRetryTime() {
        return 5;
    }

    @Override
    public boolean proceed() throws Exception{
        if(task == null) return true;
        return task.call();
    }

    @Override
    public IInitializationSituationTask withExecution(Callable<Boolean> callable) {
        task = callable;
        return this;
    }

    public SituationTask withNetWork() {
        needNetWork = true;
        return this;
    }
    public SituationTask withAccount() {
        needAccount = true;
        return this;
    }

    public SituationTask withDelay(long millis) {
        delayTime = millis;
        return this;
    }

    public IInitializationSituationTask withDependencyInitClass(Class tagClz) {
        if (tagClz == null) return this;
        dependencies.add(tagClz);
        return this;
    }

    @Override
    public IInitializationSituationTask withInitClass(Class tagClz) {
        tag = tagClz;
        return this;
    }

    @Override
    public IInitializationSituationTask withThread() {
        inThread = true;
        return this;
    }

    @Override
    public IInitializationSituationTask withHighPriority() {
        setExtraLevel(99);
        return this;
    }

    public boolean isNeedNetWork() {
        return needNetWork;
    }

    public boolean isNeedAccount() {
        return needAccount;
    }

    public long getDelayTime() {
        return delayTime;
    }

    @Override
    String getTag() {
        return super.getTag() + hashCode();
    }
}
