package com.cv.media.lib.common_utils.utils;

import android.app.AlarmManager;
import android.content.Context;
import android.text.format.Time;

import com.cv.media.lib.common_utils.callback.ICallBack;
import com.cv.media.lib.log.Logger;

import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;

import io.reactivex.Observable;
import io.reactivex.annotations.NonNull;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Function;
import io.reactivex.schedulers.Schedulers;

/**
 * Time zone utilities
 */
public class TimeZoneUtils {

    public static String getTimeZone() {
        return TimeZone.getDefault().getID();
    }

    /**
     * Need android.permission.SET_TIME_ZONE
     *
     * @param timeZoneId e.g. "Asia/Hong_Kong"  "America/New_York"
     * @return succeed or not
     */
    public static boolean setTimeZone(Context context, String timeZoneId) {
        if (StringUtils.isEmpty(timeZoneId)) {
            return false;
        }
        TimeZone curTimeZone = TimeZone.getDefault();
        //相同. ignore and return true
        if (curTimeZone.getID().equalsIgnoreCase(timeZoneId)) {
            return true;
        }
        //检查参数合法
        String[] timeZoneIds = TimeZone.getAvailableIDs();
        boolean found = false;
        for (String id : timeZoneIds) {
            if (id.equals(timeZoneId)) {
                found = true;
                break;
            }
        }
        if (!found) {
            Logger.i("Time zone id[%s] invalid", timeZoneId);
            return false;
        }
        AlarmManager mgr = (AlarmManager) context.getSystemService(Context.ALARM_SERVICE);
        mgr.setTimeZone(timeZoneId);
        return true;
    }


    public static Date timeToDate(long timeSecond) {
        if (timeSecond < 0) {
            timeSecond = 0;
        }
        int seconds = (int) (timeSecond % 60);
        int minutes = (int) ((timeSecond / 60) % 60);
        int hours = (int) (timeSecond / 3600);
        return new Date(0, 0, 0, hours, minutes, seconds);
    }


}
