//
// Source code recreated from a .class file by IntelliJ IDEA
// (powered by Fernflower decompiler)
//

package com.cv.media.lib.common_utils.crypto;

import java.io.UnsupportedEncodingException;

public class SessionKey implements IStringSerializable {
    private String did = "";
    private String userKey = "";

    public SessionKey() {
    }

    public String getDid() {
        return this.did;
    }

    public void setDid(String did) {
        this.did = did;
    }

    public String getUserKey() {
        return this.userKey;
    }

    public void setUserKey(String userKey) {
        this.userKey = userKey;
    }

    public String toSerializeString() {
        return this.did + "#!" + this.userKey;
    }

    public byte[] toSerializeBytes() {
        try {
            return this.toSerializeString().getBytes("UTF-8");
        } catch (UnsupportedEncodingException var2) {
            var2.printStackTrace();
            return new byte[0];
        }
    }

    public static SessionKey valueOf(String value) {
        if (value != null && value.length() != 0) {
            String[] strArr = value.split("#!");
            if (strArr.length != 2) {
                throw new IllegalArgumentException("Session key:" + strArr.length);
            } else {
                SessionKey sessionKey = new SessionKey();
                sessionKey.did = strArr[0];
                sessionKey.userKey = strArr[1];
                return sessionKey;
            }
        } else {
            throw new IllegalArgumentException("Session key:null");
        }
    }

    public static SessionKey valueOf(byte[] bytes) {
        return valueOf(new String(bytes));
    }
}
