package com.cv.media.lib.common_utils.crypto;

import android.util.Base64;

import com.cv.media.lib.common_utils.BuildConfig;


/**
 * Created by elegant.wang on 2016/7/16.
 */
public class SsoKey {
    // encryption 加密
    // ciphertext 密文
    // plaintext 明文
    public static String APP_CERT_AES_KEY = "";
    public static String APP_CERT_PUBLIC = "";

    public static void init(String APP_CERT_AES_KEY_CIPHER, String APP_CERT_PUBLIC_CIPHER) {
        try {
            APP_CERT_AES_KEY = SecurityUtil.getInstance().decryptString(APP_CERT_AES_KEY_CIPHER);
            APP_CERT_PUBLIC = SecurityUtil.getInstance().decryptString(APP_CERT_PUBLIC_CIPHER);
        } catch (Exception e) {
            //throw new RuntimeException(e);
        }
    }

    public static String getAppCertPublicKey() throws Exception {
        String key = AESCodecAndroid.decrypt(APP_CERT_PUBLIC, APP_CERT_AES_KEY);
        return key;
    }

    public static byte[] getAppCertPublicKeyBytes() throws Exception {
        return Base64.decode(getAppCertPublicKey(), BASE64_FLAG);
    }

    private static final int BASE64_FLAG = Base64.URL_SAFE | Base64.NO_WRAP;
    public static String getActKey(String did, String sha1Password) throws Exception {
        ActKey actKey = new ActKey();
        actKey.setDid(did);
        actKey.setSha1Pwd(sha1Password);
        byte[] rsaKey = Base64.decode(getAppCertPublicKey(), BASE64_FLAG);
        byte[] cipher = AccessKeyTools.getActKey(actKey, rsaKey);
        return Base64.encodeToString(cipher, BASE64_FLAG);
    }

    public static String getSessionKey(String did, String userKey) throws Exception {
        SessionKey sessionKey = new SessionKey();
        sessionKey.setDid(did);
        sessionKey.setUserKey(userKey);
        return Base64.encodeToString(AccessKeyTools.getSessionKey(sessionKey, getAppCertPublicKeyBytes()), BASE64_FLAG);
    }

}
