package com.cv.media.lib.common_utils.fetcher;

import java.lang.ref.SoftReference;

public abstract class Fetcher<T> {
    private SoftReference<T> ref;

    public Fetcher(boolean lazyLoad) {
        if (!lazyLoad) {
            get();
        }
    }

    protected abstract T load();

    public synchronized void setManually(T obj) {
        if (obj != null) ref = new SoftReference<>(obj);
    }

    public synchronized T get() {
        if (ref == null || ref.get() == null) {
            T obj = load();
            if (obj != null) ref = new SoftReference<>(obj);
        }
        return ref.get();
    }

    public void release() {
        ref.clear();
        ref = null;
    }
}