package com.cv.media.lib.common_utils.rxjava;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;

import androidx.annotation.NonNull;


import com.cv.media.lib.log.Logger;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.CompositeException;

/**
 * 安全Subscriber, 为了Catch住 预料不到的Exception, 通过某种方式打印日志
 *
 * @param <T>
 */
public class SafeSubscriberEx<T> implements Observer<T> {
    static Handler mHandler;
    static final int MSG_ERROR = 0xAF;

    static {
        HandlerThread thread = new HandlerThread("SafeSubscriberEx");
        thread.start();
        mHandler = new Handler(thread.getLooper(), new Handler.Callback() {
            @Override
            public boolean handleMessage(@NonNull Message msg) {
                if (msg.what == MSG_ERROR) {
                    try {
                        List<Throwable> throwables = (List<Throwable>) msg.obj;
                        String str = "SafeSubscriberEx: Exceptions receive size: " + throwables.size();
                        for (int i = 0; i < throwables.size(); i++) {
                            Throwable throwable = throwables.get(i);
                            str = str + "\n Exception " + i + " : \n";
                            str += getStackTraceString(throwable);
                        }
                        Logger.w(SafeSubscriberEx.class.getSimpleName(), str);
                    } catch (Exception ignore) {
                    }
                }
                return true;
            }
        });
    }

    Observer<T> subscriber;
    public SafeSubscriberEx(Observer<T> subscriber) {
        this.subscriber = subscriber;
    }

    @Override
    public void onComplete() {
        try {
            subscriber.onComplete();
        } catch (Throwable throwable) {
            onError(throwable);
        }
    }

    @Override
    public void onError(Throwable e) {
        try {
            if (subscriber == null) return;
            subscriber.onError(e);
        } catch (Throwable throwable) {
            try {
                ArrayList<Throwable> tmpArr = new ArrayList<>();
                if (throwable.getCause() instanceof CompositeException) {
                    List<Throwable> exs = ((CompositeException) throwable.getCause()).getExceptions();
                    if (exs != null && !exs.isEmpty()) {
                        tmpArr.addAll(exs);
                    }
                } else {
                    tmpArr.add(e);
                }
                mHandler.obtainMessage(MSG_ERROR, tmpArr).sendToTarget();
            } catch (Exception ignore) {
            }
        }
    }


    @Override
    public void onSubscribe(Disposable d) {
        subscriber.onSubscribe(d);
    }

    @Override
    public void onNext(T t) {
        try {
            subscriber.onNext(t);
        } catch (Throwable throwable) {
            onError(throwable);
        }
    }

    static String getStackTraceString(Throwable t) {
        StringWriter sw = new StringWriter(256);
        PrintWriter pw = new PrintWriter(sw, false);
        t.printStackTrace(pw);
        pw.flush();
        return sw.toString();
    }
}
