package com.cv.media.lib.common_utils.utils;

import android.content.Context;

import com.appsflyer.AppsFlyerLib;
import com.appsflyer.attribution.AppsFlyerRequestListener;

import org.apache.commons.lang3.ObjectUtils;

import java.util.HashMap;
import java.util.Map;

public class AppsFlyerHelp {

    private Map<String, Object> param;

    private AppsFlyerHelp() {
        param = new HashMap<>();
    }

    public static AppsFlyerHelp getInstance() {
        return SINGLETON.get();
    }

    private static Singleton<AppsFlyerHelp> SINGLETON = new Singleton<AppsFlyerHelp>() {
        @Override
        protected AppsFlyerHelp create() {
            return new AppsFlyerHelp();
        }
    };

    public void setCommParam(Map<String, Object> map) {
        if (ObjectUtils.isNotEmpty(param)) {
            param.clear();
        }
        if (null != param) {
            param.putAll(map);
        }
    }

    public void logEvent(Context context, String s, AppsFlyerRequestListener listen) {
        AppsFlyerLib.getInstance().logEvent(context, s, param, listen);
    }

    public void logEvent(Context context, String s) {
        AppsFlyerLib.getInstance().logEvent(context, s, param);
    }
}
