package com.cv.media.lib.common_utils.image;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.View;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.bumptech.glide.Glide;
import com.bumptech.glide.load.resource.bitmap.DownsampleStrategy;
import com.bumptech.glide.request.target.CustomViewTarget;
import com.bumptech.glide.request.transition.Transition;

import java.lang.ref.WeakReference;

import com.cv.media.lib.common_utils.async.ThreadUtils;

/**
* Glide图片加载实现层
* 职责:
* @author Damon
*/
class GlideLoader implements IImageLoader {
    public static final int TAG_URL = 0x11 << 24;
    final static MyTransform transform = MyTransform.TRANSFORM;
    final static DownsampleStrategy strategy = MyDownsampleStragegy.STRAGEGY;
    float sizeMultiplier = 1.0f;

    @Override
    public void load(Context context, Object imageSrc, Object placeholderSrc, View target) {
        if (target == null || context == null) return;
        if (imageSrc instanceof String && placeholderSrc instanceof Integer) {
            load(context, (String) imageSrc, (int) placeholderSrc, target);
        }
    }

    private void load(Context context, final String url, final int placeholderSrc, final View target) {
        final WeakReference<Context> contextRef = new WeakReference<>(context);
        String previousLoadingUrl = (String) target.getTag(TAG_URL);
        if (previousLoadingUrl != null && previousLoadingUrl.equals(url)) return;
        target.setTag(TAG_URL, url);
        ThreadUtils.execute(new Runnable() {
            @Override
            public void run() {
                try {
                    if (contextRef.get() == null) return;
                    Context ctx = contextRef.get();
                    Drawable placeDrawable = null;
                    if (placeholderSrc > 0) {
                        int requestWidth = (int) (target.getWidth() * sizeMultiplier);
                        int requestHeight = (int) (target.getHeight() * sizeMultiplier);
                        placeDrawable = Glide.with(ctx).load(placeholderSrc).downsample(strategy).submit(requestWidth, requestHeight).get();
                    }
                    Glide.with(ctx).load(url).downsample(strategy).placeholder(placeDrawable).sizeMultiplier(sizeMultiplier).transform(transform).into(new CustomViewTarget<View, Drawable>(target) {
                        @Override
                        protected void onResourceLoading(@Nullable Drawable placeholder) {
                            target.setBackground(placeholder);
                        }

                        @Override
                        public void onLoadFailed(@Nullable Drawable errorDrawable) {
                            target.setBackground(errorDrawable);
                        }

                        @Override
                        public void onResourceReady(@NonNull Drawable resource, @Nullable Transition<? super Drawable> transition) {
                            target.setBackground(resource);
                        }

                        @Override
                        protected void onResourceCleared(@Nullable Drawable placeholder) {
                            target.setBackground(placeholder);
                        }
                    });
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }
}
