package com.cv.media.lib.common_utils.utils;

import android.content.Context;

import com.appsflyer.AppsFlyerLib;
import com.appsflyer.attribution.AppsFlyerRequestListener;

import org.apache.commons.lang3.ObjectUtils;

import java.util.HashMap;
import java.util.Map;

public class AppsFlyerHelp {

    private Map<String, Object> commonParameter;

    private AppsFlyerHelp() {
        commonParameter = new HashMap<>();
    }

    public static AppsFlyerHelp getInstance() {
        return SINGLETON.get();
    }

    private static Singleton<AppsFlyerHelp> SINGLETON = new Singleton<AppsFlyerHelp>() {
        @Override
        protected AppsFlyerHelp create() {
            return new AppsFlyerHelp();
        }
    };

    public void setCommParam(Map<String, Object> commParam) {
        if (ObjectUtils.isNotEmpty(commonParameter)) {
            commonParameter.clear();
        }
        if (null != commonParameter) {
            commonParameter.putAll(commParam);
        }
    }

    public void logEvent(Context context, String s, AppsFlyerRequestListener listen) {
        AppsFlyerLib.getInstance().logEvent(context, s, commonParameter, listen);
    }

    public void logEvent(Context context, String s) {
        AppsFlyerLib.getInstance().logEvent(context, s, commonParameter);
    }

    public void logEvent(Context context, String s, Map<String, Object> param, AppsFlyerRequestListener listen) {
        if (ObjectUtils.isNotEmpty(param)) {
            commonParameter.putAll(param);
        }
        AppsFlyerLib.getInstance().logEvent(context, s, commonParameter, listen);
    }

    public void logEvent(Context context, String s, Map<String, Object> param) {
        if (ObjectUtils.isNotEmpty(param)) {
            commonParameter.putAll(param);
        }
        AppsFlyerLib.getInstance().logEvent(context, s, commonParameter);
    }
}
