package com.cv.media.lib.common_utils.webview;

import android.app.Activity;
import android.os.Bundle;
import android.webkit.WebView;
import android.webkit.WebViewClient;

import androidx.annotation.Nullable;

public class WebViewSingleProcActivity extends Activity {
    final static String WebViewSingleProc_Layout_key = "WebViewSingleProc_Layout_key";
    final static String WebViewSingleProc_Url_key = "WebViewSingleProc_Url_key";
    WebView webView;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        try {
            setContentView(getIntent().getIntExtra(WebViewSingleProc_Layout_key, 0));
            webView = getWindow().getDecorView().findViewWithTag(WebViewSingleProc.TAG_WEBVIEW);
            webView.setWebViewClient(new WebViewClient() {
                @Override
                public boolean shouldOverrideUrlLoading(WebView view, String url) {
                    view.loadUrl(url);
                    return super.shouldOverrideUrlLoading(view, url);
                }
            });
            webView.loadUrl(getIntent().getStringExtra(WebViewSingleProc_Url_key));
        } catch (Exception e) {
            finish();
        }
    }
}
