package com.cv.media.lib.common_utils.appinit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 任务排序
 * 职责: 依赖关系 排序
 * 注意: 是否存在环
 *
 * @author Damon
 */
class InitTaskSorter {
    static List<InitTask> sort(HashMap<String, IInitializationTask> src) {
        ArrayList<InitTask> tasks = new ArrayList<>();
        for (Map.Entry<String, IInitializationTask> initTaskEntry : src.entrySet()) {
            calculateLevel(((InitTask) initTaskEntry.getValue()).getTag(), src, (InitTask) initTaskEntry.getValue(), false);
            tasks.add((InitTask) initTaskEntry.getValue());
        }
        Collections.sort(tasks, (o1, o2) -> o2.getLevel() - o1.getLevel());
        return tasks;
    }

    static void calculateLevel(String initClass, HashMap<String, IInitializationTask> src, InitTask task, boolean incrementLevel) {
        if (incrementLevel) task.level++;
        for (Class dependentClass : task.dependencies) {
            if (dependentClass.getName().equals(initClass))
                throw new RuntimeException("Initialization: 依赖存在环, 依赖源头任务:" + initClass + "\t\t[触发环 源头任务:" + task.getTag() + "]");
            boolean find = false;
            for (Map.Entry<String, IInitializationTask> entry : src.entrySet()) {
                if (entry.getKey().contains(dependentClass.getName())) {
                    find = true;
                    InitTask dpTask = (InitTask) entry.getValue();
                    dpTask.setExtraLevel(dpTask.getExtraLevel() + task.getExtraLevel());
                    calculateLevel(initClass, src, dpTask, true);
                }
            }
            if (!find) {
                if (task instanceof IInitializationNormalTask)
                    throw new RuntimeException("Initialization: 依赖不存在, 触发源头任务:" + task.getTag());
            }
        }
    }
}
