package com.cv.media.lib.common_utils.utils;

import android.bluetooth.BluetoothAdapter;
import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.LocaleList;
import android.os.SystemProperties;
import android.provider.Settings;
import android.text.TextUtils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.NetworkInterface;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

import com.cv.media.lib.common_utils.provider.ContextProvider;

public class DeviceUtils {
    public static String getLocaleString() {
        //todo MyApplication.getInstance()不可能是null吧？
        //todo locale.toString 会包含国家编码，所以这里只使用语言编码
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
            LocaleList localeList = ContextProvider.getContext().getResources().getConfiguration().getLocales();
            return localeList.get(0).getLanguage().toLowerCase();
        } else {
            return ContextProvider.getContext().getResources().getConfiguration().locale.getLanguage().toLowerCase();
        }
    }

    public static Locale getLocale(Context context) {
        return context.getResources().getConfiguration().locale;
    }

//    public static String getDetectedCountryCode() {
//        return GeoIPManager.getInstance().getCountryCode();
//    }

    public static String getSupportedLocaleString() {
        String lang = getLocaleString();
        if (!"pt".equals(lang) && !"es".equals(lang) && !"en".equals(lang)) {
            lang = "en";
        }
        return lang;
    }


    private static String macCache;
    private static Object lock = new Object();

    /**
     * Android  6.0 之前（不包括6.0）
     * 必须的权限  <uses-permission android:name="android.permission.ACCESS_WIFI_STATE" />
     *
     * @return
     */
    private static String getMacDefault() {
        synchronized (lock) {
            if (macCache != null) {
                return macCache;
            }
        }

        WifiManager wifi = (WifiManager) ContextProvider.getContext().getApplicationContext()
                .getSystemService(Context.WIFI_SERVICE);
        if (wifi == null) {
            return macCache;
        }

        WifiInfo info = null;
        try {
            info = wifi.getConnectionInfo();
        } catch (Exception e) {

        }
        if (info == null) {
            return null;
        }

        synchronized (lock) {
            macCache = info.getMacAddress();
            if (!TextUtils.isEmpty(macCache)) {
                macCache = macCache.toLowerCase(Locale.ENGLISH);
            }
            return macCache;
        }
    }

    /**
     * Android 6.0（包括） - Android 7.0（不包括）
     *
     * @return
     */
    private static String getMacAddress() {
        String mac = null;
        try {
            File file = new File("/sys/class/net/wlan0/address");
            if (file.exists()) {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                mac = bufferedReader.readLine();
                bufferedReader.close();
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
        return mac;
    }

    /**
     * 遍历循环所有的网络接口，找到接口是 wlan0
     * 必须的权限 <uses-permission android:name="android.permission.INTERNET" />
     *
     * @return
     */
    private static String getMacFromHardware() {
        try {
            List<NetworkInterface> all = Collections.list(NetworkInterface.getNetworkInterfaces());
            for (NetworkInterface nif : all) {
                if (!nif.getName().equalsIgnoreCase("wlan0")) continue;
                byte[] macBytes = nif.getHardwareAddress();
                if (macBytes == null) {
                    return null;
                }

                StringBuilder res1 = new StringBuilder();
                for (byte b : macBytes) {
                    res1.append(String.format("%02x:", b));
                }

                if (res1.length() > 0) {
                    res1.deleteCharAt(res1.length() - 1);
                }
                return res1.toString();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String getWifiMac(Context context) {
        String macAddress = null;
        if (Build.VERSION.SDK_INT < Build.VERSION_CODES.M) {//5.0以下
            macAddress = getMacDefault();
        } else if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M && Build.VERSION.SDK_INT < Build.VERSION_CODES.N) {
            macAddress = getMacAddress();
        } else if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
            macAddress = getMacFromHardware();
        }
        return toShrinkMac(macAddress);
    }

    private static String getEthMacAddress() {
        String mac = null;
        try {
            File file = new File("/sys/class/net/eth0/address");
            if (file.exists()) {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                mac = bufferedReader.readLine();
                bufferedReader.close();
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
        return mac;
    }

    private static String getEthMacFromHardware() {
        try {
            List<NetworkInterface> all = Collections.list(NetworkInterface.getNetworkInterfaces());
            for (NetworkInterface nif : all) {
                if (!nif.getName().equalsIgnoreCase("eth0")) continue;
                byte[] macBytes = nif.getHardwareAddress();
                if (macBytes == null) {
                    return null;
                }

                StringBuilder res1 = new StringBuilder();
                for (byte b : macBytes) {
                    res1.append(String.format("%02x:", b));
                }

                if (res1.length() > 0) {
                    res1.deleteCharAt(res1.length() - 1);
                }
                return res1.toString();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String getEthMac(Context context) {
        String mac = null;
        mac = getEthMacAddress();
        if (TextUtils.isEmpty(mac)) {
            mac = getEthMacFromHardware();
        }
        return toShrinkMac(mac);
    }

    public static String getBluetoothMac(Context context) {
        String mac = null;
        BluetoothAdapter ba = BluetoothAdapter.getDefaultAdapter();
        if (ba != null) {
            mac = ba.getAddress();
        }
        return toShrinkMac(mac);
    }

    public static String toShrinkMac(String mac) {
        String out = "";
        if (!TextUtils.isEmpty(mac)) {
            out = mac.trim().replaceAll("[^0-9A-Fa-f]", "").toLowerCase();
        }
        return out;
    }

    /**
     * 盒子的预装渠道
     *
     * @return
     */
    public static String getPreVendorId() {
        try {
            String id = getChannelIdByResolver();
            if (!TextUtils.isEmpty(id)) {
                return id;
            }
            return SystemProperties.get("ro.preinstall.vendorid");
        } catch (Exception e) {
            return "";
        }
    }

    private static final String AUTHORITY = "com.uv.droid.uotaback.storage.provider";
    private static final Uri NOTIFY_URI = Uri.parse("content://" + AUTHORITY + "/storage");

    private static String getChannelIdByResolver() {
        String value = "";
        ContentResolver contentResolver = ContextProvider.getApplication().getContentResolver();
        String projection[] = {"value_s"};
        String selection = "_id=?";
        String selectionArgs[] = {"channelId"};
        Cursor cursor = contentResolver.query(NOTIFY_URI, projection, selection, selectionArgs, null, null);
        if (cursor != null && cursor.getCount() > 0) {
            while (cursor.moveToNext()) {
                value = cursor.getString(0);
                break;
            }
            cursor.close();
        }
        return value;
    }
}
