package com.cv.media.lib.common_utils.utils;

import android.content.Context;

import com.appsflyer.AppsFlyerLib;
import com.appsflyer.attribution.AppsFlyerRequestListener;

import org.apache.commons.lang3.ObjectUtils;

import java.util.HashMap;
import java.util.Map;

public class AppsFlyerHelp {

    private Map<String, Object> commonParameter;

    private Context mContext;

    private AppsFlyerHelp() {
        commonParameter = new HashMap<>();
    }

    public static AppsFlyerHelp getInstance() {
        return SINGLETON.get();
    }

    private static Singleton<AppsFlyerHelp> SINGLETON = new Singleton<AppsFlyerHelp>() {
        @Override
        protected AppsFlyerHelp create() {
            return new AppsFlyerHelp();
        }
    };

    public void setCommParam(Context context, Map<String, Object> commParam) {
        mContext = context;
        if (ObjectUtils.isNotEmpty(commonParameter)) {
            commonParameter.clear();
        }
        if (null != commonParameter) {
            commonParameter.putAll(commParam);
        }
    }

    public void logEvent(String s, AppsFlyerRequestListener listen) {
        AppsFlyerLib.getInstance().logEvent(mContext, s, commonParameter, listen);
    }

    public void logEvent(String s) {
        AppsFlyerLib.getInstance().logEvent(mContext, s, commonParameter);
    }

    public void logEvent(String s, Map<String, Object> param, AppsFlyerRequestListener listen) {
        if (ObjectUtils.isNotEmpty(param) && null != commonParameter) {
            commonParameter.putAll(param);
        }
        AppsFlyerLib.getInstance().logEvent(mContext, s, commonParameter, listen);
    }

    public void logEvent(String s, Map<String, Object> param) {
        if (ObjectUtils.isNotEmpty(param) && null != commonParameter) {
            commonParameter.putAll(param);
        }
        AppsFlyerLib.getInstance().logEvent(mContext, s, commonParameter);
    }
}
