package com.cv.media.lib.common_utils.image;

import com.bumptech.glide.load.resource.bitmap.DownsampleStrategy;

/**
* 大则缩, 小则保持
* 职责:
* @author Damon
*/
class MyDownsampleStragegy extends DownsampleStrategy {
    public static final DownsampleStrategy STRAGEGY = new MyDownsampleStragegy();

    @Override
    public float getScaleFactor(int sourceWidth, int sourceHeight, int requestedWidth, int requestedHeight) {
        if (sourceHeight <= requestedHeight && sourceWidth <= requestedWidth) {
            //图小于控件大小, 不变
            return 1;
        }else  {
            //图大于控件大小, 缩
            float scaleFactorWidth = requestedWidth / (float)sourceWidth;
            float scaleFactorHeight = requestedHeight / (float)sourceHeight;
            return Math.min(scaleFactorWidth, scaleFactorHeight);
        }
    }

    @Override
    public SampleSizeRounding getSampleSizeRounding(int sourceWidth, int sourceHeight, int requestedWidth, int requestedHeight) {
        return SampleSizeRounding.QUALITY;
    }
}
