package com.cv.media.lib.common_utils.appinit;

/**
* 正常任务
* 职责:
* @author Damon
*/
final class NormalTask extends InitTask implements IInitializationNormalTask{
    private Runnable runnable;

    public NormalTask() {
        super();
    }

    @Override
    protected boolean proceed() {
        if(runnable != null) runnable.run();
        return true;
    }

    @Override
    public IInitializationNormalTask withExecution(Runnable runnable) {
        this.runnable = runnable;
        return this;
    }

    public IInitializationNormalTask withDependencyInitClass(Class tagClz) {
        if (tagClz == null) return this;
        dependencies.add(tagClz);
        return this;
    }

    @Override
    public IInitializationNormalTask withInitClass(Class tagClz) {
        this.tag = tagClz;
        return this;
    }

    @Override
    public IInitializationNormalTask withThread() {
        this.inThread = true;
        return this;
    }

    @Override
    public IInitializationNormalTask withHighPriority() {
        setExtraLevel(99);
        return this;
    }

    @Override
    public IInitializationNormalTask withName(String name) {
        setName(name);
        return this;
    }
}
