package com.cv.media.lib.common_utils.crypto;

import com.cv.media.lib.common_utils.utils.ByteHexUtils;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class SHA {
    MessageDigest digest = null;

    public SHA() {
        try {
            this.digest = MessageDigest.getInstance("SHA-1");
        } catch (NoSuchAlgorithmException var2) {
        }

    }

    public void update(String content) {
        if (this.digest != null) {
            try {
                this.digest.update(content.getBytes("UTF-8"));
            } catch (UnsupportedEncodingException var3) {
                throw new IllegalArgumentException(var3.getMessage());
            }
        }

    }

    public String checksum() {
        return this.digest == null ? "" : ByteHexUtils.byte2hex(this.digest.digest(), false);
    }

    public static String sha1(String content) {
        SHA sha = new SHA();
        sha.update(content);
        return sha.checksum();
    }
}