//
// Source code recreated from a .class file by IntelliJ IDEA
// (powered by Fernflower decompiler)
//

package com.cv.media.lib.common_utils.crypto;


import com.cv.media.lib.common_utils.encrypt.AESUtils;
import com.cv.media.lib.common_utils.encrypt.RSAUtils;

public class AccessKeyTools {
    public AccessKeyTools() {
    }

    public static byte[] getActKey(ActKey actKey, byte[] appkey) throws Exception {
        return getAccessKey(actKey, appkey);
    }

    public static byte[] getSessionKey(SessionKey sessionKey, byte[] appkey) throws Exception {
        return getAccessKey(sessionKey, appkey);
    }

    public static byte[] getAccessKey(IStringSerializable dataObject, byte[] appkey) throws Exception {
        return RSAUtils.encryptByPublicKey(dataObject.toSerializeString().getBytes(), appkey);
    }

    public static boolean verify(byte[] data, byte[] clientKey, byte[] sign) throws Exception {
        return RSAUtils.verify(data, clientKey, sign);
    }

    public static String getAppkey(byte[] data, byte[] key) throws Exception {
        return AESUtils.decrypt(data, key);
    }
}
