package com.cv.media.lib.common_utils.ntp;

import android.os.SystemClock;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;


public class SntpTimeProvider implements TimeProvider {
    public final static int NETWORK_TIMEOUT_MILLIS = 5000;
    private final static List<String> ntpServers = new ArrayList<>();

    static {
        ntpServers.add("0.pool.ntp.org");
        ntpServers.add("176.9.118.9");
        ntpServers.add("1.pool.ntp.org");
        ntpServers.add("61.216.153.106");
        ntpServers.add("2.pool.ntp.org");
        ntpServers.add("203.135.184.123");
        ntpServers.add("3.pool.ntp.org");
        ntpServers.add("108.59.2.24");
        ntpServers.add("0.south-america.pool.ntp.org");
        ntpServers.add("200.189.40.8");
        ntpServers.add("1.south-america.pool.ntp.org");
        ntpServers.add("164.73.227.4");
        ntpServers.add("2.south-america.pool.ntp.org");
        ntpServers.add("200.192.232.8");
        ntpServers.add("3.south-america.pool.ntp.org");
        ntpServers.add("201.217.3.86");
        ntpServers.add("time.google.com");
        ntpServers.add("216.239.35.12");
    }

    private SntpClient client;
    private boolean initialized;
    private long sntpTime;
    private long lastUpdateTicks;

    public SntpTimeProvider() {
        client = new SntpClient();
    }

    public boolean requestNtpTime() {
        if (!cacheExpired()) return true;
        for (String ntpServer : ntpServers) {
            if (client.requestTime(ntpServer, NETWORK_TIMEOUT_MILLIS)) {
                sntpTime = client.getNtpTime() + SystemClock.elapsedRealtime() - client.getNtpTimeReference();
                lastUpdateTicks = SystemClock.elapsedRealtime();
                initialized = true;
                //Timber.i("ntp success from: %s", ntpServer);
                return true;
            }
        }
        //TimberUtils.e("fail to get NTP from: %s", ntpServers);
        return false;
    }

    @Override
    public Date now() {
        return new Date(sntpTime + SystemClock.elapsedRealtime() - lastUpdateTicks);
    }

    @Override
    public long currentTimeMillis() {
        return sntpTime + SystemClock.elapsedRealtime() - lastUpdateTicks;
    }

    @Override
    public boolean wasInitialized() {
        return initialized;
    }

    private boolean cacheExpired() {
        return !wasInitialized() || (wasInitialized() && SystemClock.elapsedRealtime() - lastUpdateTicks >= TimeUnit.MINUTES.toMillis(60));
    }
}
