package com.cv.media.lib.common_utils.utils;

import android.content.Context;

import com.appsflyer.AppsFlyerLib;
import com.appsflyer.attribution.AppsFlyerRequestListener;
import com.cv.media.lib.log.Logger;

import org.apache.commons.lang3.ObjectUtils;

import java.util.HashMap;
import java.util.Map;

public class AppsFlyerHelp {
    private static final String TAG = AppsFlyerHelp.class.getSimpleName();
    private final Map<String, Object> commonParameter;

    private Context mContext;

    private AppsFlyerHelp() {
        commonParameter = new HashMap<>();
    }

    public static AppsFlyerHelp getInstance() {
        return SINGLETON.get();
    }

    private static final Singleton<AppsFlyerHelp> SINGLETON = new Singleton<AppsFlyerHelp>() {
        @Override
        protected AppsFlyerHelp create() {
            return new AppsFlyerHelp();
        }
    };

    public void setCommParam(Context context, Map<String, Object> commParam) {
        if (commParam == null) {
            throw new IllegalArgumentException("parma map should not be null");
        }

        mContext = context;
        if (ObjectUtils.isNotEmpty(commonParameter)) {
            commonParameter.clear();
        }
        if (ObjectUtils.isNotEmpty(commParam)) {
            commonParameter.putAll(commParam);
        } else {
            Logger.w(TAG, "commParam map is empty");
        }
    }

    public void logEvent(String s, AppsFlyerRequestListener listen) {
        AppsFlyerLib.getInstance().logEvent(mContext, s, commonParameter, listen);
    }

    public void logEvent(String s) {
        AppsFlyerLib.getInstance().logEvent(mContext, s, commonParameter);
    }

    public void logEvent(String s, Map<String, Object> param, AppsFlyerRequestListener listen) {
        if (param == null) {
            throw new IllegalArgumentException("parma map should not be null");
        }

        if (ObjectUtils.isNotEmpty(param)) {
            param.putAll(commonParameter);
        } else {
            Logger.w(TAG, "param map is empty");
        }
        AppsFlyerLib.getInstance().logEvent(mContext, s, param, listen);
    }

    public void logEvent(String s, Map<String, Object> param) {
        if (param == null) {
            throw new IllegalArgumentException("parma map should not be null");
        }

        if (ObjectUtils.isNotEmpty(param)) {
            param.putAll(commonParameter);
        } else {
            Logger.w(TAG, "param map is empty");
        }
        AppsFlyerLib.getInstance().logEvent(mContext, s, param);
    }
}
