package com.cv.media.lib.common_utils.keyevent;
import android.view.KeyEvent;

/**
*  按键事件收集匹配器
* 职责:
*/
class MyMultiKeyTrigger  {
    private static final String TAG = MyMultiKeyTrigger.class.getSimpleName();

    private boolean isAllowTrigger = false;
    //组合键序列
    private int[] MULT_KEY = new int[]{};
    //是否限定要在时间间隔里再次输入按键
    private static boolean ALLAW_SETTING_DELAYED_FLAG= true;
    //允许用户在多少时间间隔里输入按键
    private static int CHECK_NUM_ALLAW_MAX_DELAYED = 2000;
    //记录用户连续输入了多少个有效的键
    private int check_num = 0;
    //最后一次用户输入按键的时间
    private static long lastEventTime = 0;

    private KeyAction keyAction;

    private MyMultiKeyTrigger() {}

    public MyMultiKeyTrigger(boolean isAllowTrigger,  String multiKey, KeyAction keyAction) {
        this.isAllowTrigger = isAllowTrigger;
        MULT_KEY = new int[multiKey.length()];
        for(int i = 0; i < multiKey.length(); i++) {
            MULT_KEY[i] = Integer.valueOf(String.valueOf(multiKey.charAt(i)));
        }

        this.keyAction = keyAction;
    }

    
    public boolean allowTrigger() {
        return isAllowTrigger;
    }

    public boolean onKeyEvent(KeyEvent event) {
        if(event.getAction() == KeyEvent.ACTION_UP) {
            return checkKey(event.getKeyCode(), event.getEventTime());
        }
        return false;
    }
    private boolean checkKey(int keycode, long eventTime) {
        // TODO Auto-generated method stub
        boolean check;
        int delayed;
        //转换为实际数值
        int num = keycode - KeyEvent.KEYCODE_0;
//        Log.i(TAG, "checkKey lastEventTime="+lastEventTime);
//        Log.i(TAG, "checkKey num= "+num+" , eventTime = "+eventTime);
        //首次按键
        if(lastEventTime==0){
            delayed = 0;
        }else{
            //非首次按键
            delayed = (int)(eventTime-lastEventTime);
        }
        check = checkKeyValid(num, delayed);

        lastEventTime = check?eventTime:0L;

//        Log.i(TAG, "checkKey check key valid = "+check);

        if(check && checkMultKey()) {
            //执行触发
            onTrigger();
            //触发完成后清除掉原先的输入
            clearKeys();
        }
        return check;
    }

    
    public boolean checkMultKey() {
        // TODO Auto-generated method stub
        return check_num == MULT_KEY.length;
    }

    
    public void clearKeys() {
// TODO Auto-generated method stub
        lastEventTime = 0;
        check_num = 0;
    }

    
    public void onTrigger() {
// TODO Auto-generated method stub
        //只有完成组合键的输入后才能触发弹出提示框
        if(checkMultKey()){
//            startAlert();
            if(isAllowTrigger && null != keyAction) {
                keyAction.callback();
            }
        }else{
            //否则不能随便就调用触发
            throw new RuntimeException("you must be sure checkMultKey() is return true.");
        }
    }

    private void startAlert() {

    }

    /**
     * 传入用户输入的按键
     * @param num
     * @param delayed 两次按键之间的时间间隔
     * @return
     */
    private  boolean checkKeyValid(int num,int delayed){
//        Log.i(TAG, "checkKey num= "+num+" , delayed = "+delayed);
        //如果超过最大时间间隔，则重置
        if(ALLAW_SETTING_DELAYED_FLAG&& delayed>CHECK_NUM_ALLAW_MAX_DELAYED){
            check_num = 0;
            return false;
        }
        //如果输入的数刚好等于校验位置的数，则有效输入+1
        if(check_num<MULT_KEY.length&&MULT_KEY[check_num]==num){
            check_num++;
            return true;
        }else{
            check_num = 0;//如果输入错误的话，则重置掉原先输入的
        }
        return false;
    }

    public interface KeyAction {
        void callback();
    }
}
