package com.cv.media.lib.common_utils.appstat.features;

import android.app.Activity;
import android.content.ComponentName;

import java.util.List;

import io.reactivex.Observable;

/**
*  Activity层面
* 职责:
* @author Damon
*/
public interface IActivitiesFeatures {
    Activity getTopActivity();
    List<Activity> getAllActivity();
    void clearAllActivity();
    void addActivitiesEventListener(IActivitiesEventListener listener);
    void removeActivitiesEventListener(IActivitiesEventListener listener);

    interface IActivitiesEventListener {
        void onNewActivityIn(ComponentName newActivity, ComponentName invokeActivity);
    }
}
