package com.cv.media.lib.common_utils.utils;

import android.util.Log;
import java.lang.reflect.Method;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

/**
 * 反射安全工具类
 * 提供安全的反射操作，处理各种兼容性问题
 * 
 * @author CV Media Library
 */
public class ReflectionSafetyUtils {
    private static final String TAG = "ReflectionSafetyUtils";
    
    /**
     * 安全地获取类的方法列表，处理各种兼容性问题
     * @param clazz 要扫描的类
     * @return 安全的方法列表
     */
    public static List<Method> getDeclaredMethodsSafely(Class<?> clazz) {
        List<Method> safeMethods = new ArrayList<>();
        
        if (clazz == null) {
            return safeMethods;
        }
        
        try {
            Method[] declaredMethods = clazz.getDeclaredMethods();
            for (Method method : declaredMethods) {
                try {
                    // 尝试访问方法属性，如果遇到类加载问题则跳过
                    method.getReturnType();
                    safeMethods.add(method);
                } catch (NoClassDefFoundError e) {
                    // 跳过包含不可用类的方法
                    Log.w(TAG, "跳过方法 " + method.getName() + ": " + e.getMessage());
                } catch (Exception e) {
                    // 跳过其他异常的方法
                    Log.w(TAG, "跳过方法 " + method.getName() + ": " + e.getMessage());
                }
            }
        } catch (NoClassDefFoundError e) {
            Log.w(TAG, "类 " + clazz.getName() + " 存在类加载问题: " + e.getMessage());
        } catch (Exception e) {
            Log.w(TAG, "扫描类 " + clazz.getName() + " 时发生异常: " + e.getMessage());
        }
        
        return safeMethods;
    }
    
}
