package com.cv.media.lib.common_utils.debug;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.util.Printer;

import java.util.HashMap;

/**
* 基于消息队列机制 进行 主线程消息事件执行时间 的 监控
* 职责:
* @author Damon
*/
public class UIBlockChecker {
    private long startTime;
    private StringBuilder stringBuilder;
    private CallBack cb;
    private HandlerThread handlerThread;
    private Handler debugH;
    private long timeFilter;
    private volatile HashMap<Long, String> map;
    private HashMap<Long, Runnable> runnables;

    private UIBlockChecker() {
        stringBuilder = new StringBuilder();
        handlerThread = new HandlerThread("DebugUI");
        handlerThread.start();
        debugH = new Handler(handlerThread.getLooper());
        map = new HashMap<>();
        runnables = new HashMap<>();
    }

    public void start(long maxTime, CallBack callBack) {
        cb = callBack;
        timeFilter = maxTime;
        Looper.getMainLooper().setMessageLogging(new Printer() {
            @Override
            public void println(final String x) {
                if (x.contains(">>>")) {
                    startTime = System.currentTimeMillis();
                    final long startTimeRef = startTime;
                    Runnable runnable = new Runnable() {
                        @Override
                        public void run() {
                            stringBuilder.setLength(0);
                            StackTraceElement[] stacks = Looper.getMainLooper().getThread().getStackTrace();
                            stringBuilder.append(x);
                            for (int i = 0; i < stacks.length; i++) {
                                if (stacks[i].toString().contains("com.")) {
                                    stringBuilder.append("\n" + stacks[i]);
                                }
                            }
                            stringBuilder.append("\n>>>>>>>>>>>>>>>>>>>>>Block<<<<<<<<<<<<<<<<<<<<<\n");
                            map.put(startTimeRef, stringBuilder.toString());
                        }
                    };
                    runnables.put(startTimeRef, runnable);
                    debugH.postDelayed(runnable, (long) (timeFilter * 0.9));
                    debugH.postDelayed(new Runnable() {
                        @Override
                        public void run() {
                            String info = map.remove(startTimeRef);
                            if (info != null && cb != null) {
                                cb.onBlock(info + " ANR");
                            }
                        }
                    }, 5000);
                } else if (x.contains("<<<")) {
                    long endTime = System.currentTimeMillis() - startTime;
                    if (endTime > timeFilter && cb != null) {
                        String info = map.remove(startTime);
                        if (info != null) {
                            cb.onBlock(info + "用时:" + endTime + "ms");
                        }
                    } else {
                        map.remove(startTime);
                        debugH.removeCallbacks(runnables.remove(startTime));
                    }
                }
            }
        });
    }

    public interface CallBack {
        void onBlock(String stacktrace);
    }

    public static void check(long maxTime, CallBack cb) {
        new UIBlockChecker().start(maxTime, cb);
    }
}
