//
// Source code recreated from a .class file by IntelliJ IDEA
// (powered by Fernflower decompiler)
//

package com.cv.media.lib.common_utils.crypto;

import java.io.UnsupportedEncodingException;

public class ActKey implements IStringSerializable {
    private String did = "";
    private String sha1Pwd = "";

    public ActKey() {
    }

    public String getDid() {
        return this.did;
    }

    public void setDid(String did) {
        this.did = did;
    }

    public String getSha1Pwd() {
        return this.sha1Pwd;
    }

    public void setSha1Pwd(String sha1Pwd) {
        this.sha1Pwd = sha1Pwd;
    }

    public String toSerializeString() {
        return this.did + "#!" + this.sha1Pwd;
    }

    public byte[] toSerializeBytes() {
        try {
            return this.toSerializeString().getBytes("UTF-8");
        } catch (UnsupportedEncodingException var2) {
            var2.printStackTrace();
            return new byte[0];
        }
    }

    public static ActKey valueOf(String value) {
        if (value != null && value.length() != 0) {
            String[] strArr = value.split("#!");
            if (strArr.length != 2) {
                throw new IllegalArgumentException("Activate key");
            } else {
                ActKey actKey = new ActKey();
                actKey.did = strArr[0];
                actKey.sha1Pwd = strArr[1];
                return actKey;
            }
        } else {
            throw new IllegalArgumentException("Session key:null");
        }
    }

    public static ActKey valueOf(byte[] bytes) {
        return valueOf(new String(bytes));
    }
}
