package com.cv.media.lib.common_utils.appguard;

import android.app.Activity;
import android.app.Application;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.util.ArrayMap;
import android.util.Log;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.cv.media.lib.common_utils.appstat.AppManager;
import com.cv.media.lib.common_utils.rxjava.StreamController;
import com.cv.media.lib.common_utils.utils.Singleton;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

import io.reactivex.Observable;

/**
* 程序守护
* 职责: 不同的场景下 做一些操作
 * 1. Crash: 清空Activity栈
 * 2. Open app after killed by LowMemoryKiller: 以新任务方式  启动 App 入口Activity
* @author Damon
*/
public class AppGuard {
    private CrashHandler crashHandler;
    private StreamController<Throwable> scCrash = new StreamController<>();
    private StreamController<Object> scMemoryKill = new StreamController<>();
    private MemoryKillHandler mkHandler;
    static Singleton<AppGuard> mInstance = new Singleton<AppGuard>() {
        @Override
        protected AppGuard create() {
            return new AppGuard();
        }
    };

    public static AppGuard getInstance() {
        return mInstance.get();
    }



    public void start(Application application, Class<? extends Activity> firstActivityClazz, Class<? extends Activity> crashActivity) {
        crashHandler = new CrashHandler(scCrash);
        crashHandler.init();
        mkHandler = new MemoryKillHandler(scMemoryKill, firstActivityClazz, crashActivity);
        application.registerActivityLifecycleCallbacks(mkHandler);
    }

    public Observable<Throwable> onAppCrashStream() {
        return scCrash.stream();
    }

    public Observable<Object> onAppRestoreStream() {
        return scMemoryKill.stream();
    }

    static class CrashHandler implements Thread.UncaughtExceptionHandler {
        private Thread.UncaughtExceptionHandler mOldHandler;
        private StreamController<Throwable> streamController;

        public CrashHandler(StreamController<Throwable> streamController) {
            this.streamController = streamController;
        }

        public void init() {
            mOldHandler = Thread.getDefaultUncaughtExceptionHandler();// 获取系统默认的UncaughtException处理器
            Thread.setDefaultUncaughtExceptionHandler(this);// 设置该CrashHandler为程序的默认处理器
        }

        @Override
        public void uncaughtException(Thread thread, Throwable ex) {
            AppManager.INSTANCE.getActivities().clearAllActivity();
            streamController.push(ex);
            if (mOldHandler != null) {
                mOldHandler.uncaughtException(thread, ex);
            }
        }
    }

    static class MemoryKillHandler implements Application.ActivityLifecycleCallbacks {
        Class rootActivityClz;
        Class crashActivityClz;
        boolean isFirst = true;
        StreamController<Object> scMemoryKill;
        public MemoryKillHandler(StreamController<Object> scMemoryKill, Class rootActivityClz, Class crashActivityClz) {
            this.rootActivityClz = rootActivityClz;
            this.crashActivityClz = crashActivityClz;
            this.scMemoryKill = scMemoryKill;
        }

        @Override
        public void onActivityCreated(@NonNull Activity activity, @Nullable Bundle savedInstanceState) {
            //Log.v("ttt", "onActivityCreated: " + activity.getClass().getSimpleName());
            if(isFirst && (rootActivityClz != null && activity.getClass() != rootActivityClz && activity.getClass() != crashActivityClz && !(activity instanceof FirstPageCheckIgnore))) {
                scMemoryKill.push(new Object());
                activity.finish();
                Intent intent = new Intent(activity, rootActivityClz);
                intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_ACTIVITY_CLEAR_TASK | Intent.FLAG_ACTIVITY_RESET_TASK_IF_NEEDED);
                activity.startActivity(intent);
            }
            isFirst = false;
        }

        private int getActivities () {
            try {
                Class activityThreadClass = Class.forName("android.app.ActivityThread");
                Object activityThread = activityThreadClass.getMethod("currentActivityThread").invoke(null);
                Field activitiesField = activityThreadClass.getDeclaredField("mActivities");
                activitiesField.setAccessible(true);

                Map<Object, Object> activities;
                if (Build.VERSION.SDK_INT < Build.VERSION_CODES.KITKAT) {
                    activities = (HashMap<Object, Object>) activitiesField.get(activityThread);
                } else {
                    activities = (ArrayMap<Object, Object>) activitiesField.get(activityThread);
                }
                return activities.size();
            } catch (Exception e) {
                e.printStackTrace();
            }
            return 0;
        }

        @Override
        public void onActivityStarted(@NonNull Activity activity) {

        }

        @Override
        public void onActivityResumed(@NonNull Activity activity) {
        }

        @Override
        public void onActivityPaused(@NonNull Activity activity) {

        }

        @Override
        public void onActivityStopped(@NonNull Activity activity) {

        }

        @Override
        public void onActivitySaveInstanceState(@NonNull Activity activity, @NonNull Bundle outState) {

        }

        @Override
        public void onActivityDestroyed(@NonNull Activity activity) {

        }
    }

    public void tearCrash() {
        new Handler().postDelayed(new Runnable() {
            @Override
            public void run() {
                Object a = null;
                a.toString();
            }
        }, 5000);
    }
}
