package com.cv.media.lib.common_utils.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class TimeUtils {

    public static String getFormattedRfc1123DateUtc(Date date) {
        return getRfc1123Format().format(date);
    }

    public static SimpleDateFormat getRfc1123Format() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return simpleDateFormat;
    }

    /*
   * 毫秒转化时分秒毫秒
   */
    public static String formatTime(Long ms) {
        Integer ss = 1000;
        Integer mi = ss * 60;
        Integer hh = mi * 60;
        Integer dd = hh * 24;

        Long day = ms / dd;
        Long hour = (ms - day * dd) / hh;
        Long minute = (ms - day * dd - hour * hh) / mi;
//        Long second = (ms - day * dd - hour * hh - minute * mi) / ss;
//        Long milliSecond = ms - day * dd - hour * hh - minute * mi - second * ss;

        StringBuffer sb = new StringBuffer();
        if(day > 0) {
            sb.append(day+"D");
        }
        if(hour >= 0) {
            sb.append(hour+"H");
        }
        if(day <=0 && minute >= 0) {
            sb.append(minute+"Min");
        }
//        if(day<=0 && hour <=0 && second > 0) {
//            sb.append(second+"S");
//        }
//        if(milliSecond > 0) {
//            sb.append(milliSecond+"毫秒");
//        }
        return sb.toString();
    }

    private final static String DATE_FORMAT1 = "yyyy-MM-dd HH:mm:ss";
    private final static String DATE_FORMAT2 = "yyyy/MM/dd";

    public static String timeStamp2DateStr(long timeStamp){
        String dateStr = null;
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT1);
        Date date = new Date(timeStamp);
        dateStr = dateFormat.format(date);
        return dateStr;
    }

    public static String timeStamp2DateStr2(long timeStamp){
        String dateStr = null;
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT2);
        Date date = new Date(timeStamp);
        dateStr = dateFormat.format(date);
        return dateStr;
    }

    public static String timeStamp2DateStr(String timeStampStr){
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT1);
        Date date = new Date(Long.valueOf(timeStampStr));
        return dateFormat.format(date);
    }

    public static Date timeStamp2Date(long timeStamp){
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT1);
        Date date = new Date(timeStamp);
        return date;
    }

    public static long dateStr2TimeStamp(String dateStr){
        long timeStamp = 0;
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT1);
            Date date = dateFormat.parse(dateStr);
            timeStamp = date.getTime();
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return timeStamp;
    }

    public static String date2DateStr(Date date){
        if(date == null)return "";
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT1);
        String dataStr = dateFormat.format(date);
        return dataStr;
    }

    public static Date dateStr2Date(String dateStr){
        if(dateStr == null || dateStr.equals("null"))return null;
        Date date = null;
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT1);
            date = dateFormat.parse(dateStr);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }

    public static int getYear(Date date){
        return date.getYear();
    }

    public static int getMonth(Date date){
        return date.getMonth();
    }

    public static int getDay(Date date){
        return date.getDay();
    }

    public static int getHours(Date date){
        return date.getHours();
    }

    public static int getMinutes(Date date){
        return date.getMinutes();
    }

    public static int getSeconds(Date date){
        return date.getSeconds();
    }

    public static String secToTime(long seconds) {
        if (seconds<=0){
            return "00:00";
        }
        long hour = seconds / 60 / 60;
        long minutes = seconds / 60 % 60;
        long remainingSeconds = seconds % 60;

        StringBuffer sb = new StringBuffer();
        if (hour > 0) {
            sb.append(unitFormat(hour) + ":");
        }
        if (minutes >= 0) {
            sb.append(unitFormat(minutes) + ":");
        }
        if (remainingSeconds >= 0) {
            sb.append(unitFormat(remainingSeconds));
        }
        return sb.toString();
    }

    private static String unitFormat(long i) {
        String retStr = "";
        if (i >= 0 && i < 10) {
            retStr = "0" + i;
        } else {
            retStr = "" + i;
        }
        return retStr;
    }

}

