package com.cv.media.lib.common_utils.rxjava;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.annotations.NonNull;
import io.reactivex.disposables.Disposable;

/**
* 流
* 职责:
* @author Damon
*/
public class StreamController<T> {
    private Observable<T> observable;
    private boolean isDispose = false;

    private final List<ObservableEmitter<T>> emitters = new CopyOnWriteArrayList<>();

    public StreamController() {
        this.observable = Observable.create(emitter -> {
            emitters.add(emitter);
            emitter.setDisposable(new Dispose(emitter));
        });
    }

    public void push(T object) {
        for (ObservableEmitter<T> emitter : emitters) {
            emitter.onNext(object);
        }
    }

    public void error(Throwable throwable) {
        for (ObservableEmitter<T> emitter : emitters) {
            emitter.onError(throwable);
        }
    }

    public Observable<T> stream(){
        return observable;
    }

    public boolean hasBeenObserve() {
        return emitters.size() >0;
    }

    class Dispose implements Disposable {
        private ObservableEmitter<T> emitter;

        public Dispose(ObservableEmitter<T> emitter) {
            this.emitter = emitter;
        }

        @Override
        public void dispose() {
            emitters.remove(emitter);
            emitter = null;
            isDispose = true;
        }

        @Override
        public boolean isDisposed() {
            return isDispose;
        }
    }
}
