package com.cv.media.lib.common_utils.ntp;

import android.os.SystemClock;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class WebTimeProvider implements TimeProvider {
    private final static List<String> webServers = new ArrayList<>();

    static {
        webServers.add("http://www.google.com");
        webServers.add("http://www.baidu.com");
    }

    private boolean initialized;
    private long webTime;
    private long lastUpdateTicks;

    @Override
    public Date now() {
        return new Date(currentTimeMillis());
    }

    @Override
    public long currentTimeMillis() {
        return webTime + SystemClock.elapsedRealtime() - lastUpdateTicks;
    }

    @Override
    public boolean wasInitialized() {
        return initialized;
    }

    public boolean requestWebTime() {
        if (!cacheExpired()) return true;
        for (String server : webServers) {
            if (requestServerTime(server)) {
                return true;
            }
        }
        return false;
    }

    // 封装对单个服务器的请求
    private boolean requestServerTime(String server) {
        HttpURLConnection httpURLConnection = null;
        try {
            URL url = new URL(server);
            httpURLConnection = (HttpURLConnection) url.openConnection();
            httpURLConnection.setConnectTimeout(15000); // 设置连接超时
            long date = httpURLConnection.getDate();    // 获取响应头中的时间
            httpURLConnection.disconnect();  // 断开连接

            if (date > 0) {
                // 如果获取到有效时间，更新 webTime 和 lastUpdateTicks
                webTime = date;
                lastUpdateTicks = SystemClock.elapsedRealtime();
                initialized = true;
//                TimberUtils.e("Web time is %s", "" + date);
                return true;
            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }

        return false;
    }


    private boolean cacheExpired() {
        return !wasInitialized() || (wasInitialized() && SystemClock.elapsedRealtime() - lastUpdateTicks >= TimeUnit.MINUTES.toMillis(60));
    }
}
