package com.cv.media.lib.common_utils.utils.storage;

import android.content.Context;
import android.os.Build;
import android.os.Environment;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.StatFs;
import android.os.storage.StorageManager;
import android.util.Log;

import androidx.core.os.EnvironmentCompat;

import com.cv.media.lib.log.Logger;

import java.io.File;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class StorageUtils {
    private final static String TAG = StorageUtils.class.getSimpleName();

    public static int getFreeSpace(){
        long dataFreeSpace = Environment.getDataDirectory().getFreeSpace();
        int freeSpace = (int)(dataFreeSpace/(1024*1024));
        Logger.i(TAG, "freeSpace : "+freeSpace+"MB");
        return freeSpace;
//        return 0;
    }

    public static int availableSpace(){
        int freeSpace = 0;
        File file = new File("/sdcard");
        if(file != null){
            long space = file.getFreeSpace();
            freeSpace = (int)(space/(1024*1024*1024));
            Logger.i(TAG, "freeSpace"+space+";available space :"+freeSpace+"G");
        }else {
            Logger.e(TAG, "the file is not exist!");
        }
        return freeSpace;
    }

    public static void getStorage(Context context){
        context.getFilesDir().getAbsolutePath();
    }

    public static long getTotalInternalMemorySize() {
        File path = Environment.getDataDirectory();
        StatFs stat = new StatFs(path.getPath());
        long blockSize = stat.getBlockSizeLong();
        long totalBlocks = stat.getBlockCountLong();
        return totalBlocks * blockSize;
    }

    public static ArrayList<StorageBean> getStorageData(Context pContext) {
        final StorageManager storageManager = (StorageManager) pContext.getSystemService(Context.STORAGE_SERVICE);
        try {
            //得到StorageManager中的getVolumeList()方法的对象
            final Method getVolumeList = storageManager.getClass().getMethod("getVolumeList");
            //---------------------------------------------------------------------

            //得到StorageVolume类的对象
            final Class<?> storageVolumeClazz = Class.forName("android.os.storage.StorageVolume");
            //---------------------------------------------------------------------
            //获得StorageVolume中的一些方法
            final Method getPath = storageVolumeClazz.getMethod("getPath");
            Method isRemovable = storageVolumeClazz.getMethod("isRemovable");
            Method getDiscription = storageVolumeClazz.getMethod("getDescription", Context.class);

            Method mGetState = null;
            //getState 方法是在4.4_r1之后的版本加的，之前版本（含4.4_r1）没有
            // （http://grepcode.com/file/repository.grepcode.com/java/ext/com.google.android/android/4.4_r1/android/os/Environment.java/）
            if (Build.VERSION.SDK_INT > Build.VERSION_CODES.KITKAT) {
                try {
                    mGetState = storageVolumeClazz.getMethod("getState");
                } catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
            }
            //---------------------------------------------------------------------

            //调用getVolumeList方法，参数为：“谁”中调用这个方法
            final Object invokeVolumeList = getVolumeList.invoke(storageManager);
            //---------------------------------------------------------------------
            final int length = Array.getLength(invokeVolumeList);
            ArrayList<StorageBean> list = new ArrayList<>();
            for (int i = 0; i < length; i++) {
                final Object storageVolume = Array.get(invokeVolumeList, i);//得到StorageVolume对象
                final String path = (String) getPath.invoke(storageVolume);
                final String description = (String) getDiscription.invoke(storageVolume, pContext);
                final boolean removable = (Boolean) isRemovable.invoke(storageVolume);
                String state = null;
                if (mGetState != null) {
                    state = (String) mGetState.invoke(storageVolume);
                } else {
                    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT) {
                        state = Environment.getStorageState(new File(path));
                    } else {
                        if (removable) {
                            state = EnvironmentCompat.getStorageState(new File(path));
                        } else {
                            //不能移除的存储介质，一直是mounted
                            state = Environment.MEDIA_MOUNTED;
                        }
                    }
                }
                final String msg = "path==" + path
                        + " ,description==" + description
                        + " ,removable==" + removable
                        + ",state==" + state;
                Log.e(TAG, msg);
                StorageBean storageBean = new StorageBean();
                storageBean.setMounted(state);
                storageBean.setPath(path);
                storageBean.setDescription(description);
                storageBean.setRemovable(removable);
                list.add(storageBean);
            }
            return list;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static StorageBean getInternalSdcard() {
        StorageBean storageBean = new StorageBean();
        storageBean.setPath(Environment.getExternalStorageDirectory().getPath());
        storageBean.setRemovable(false);
        storageBean.setDescription("Local Disk");
        return storageBean;
    }

    public static class StorageBean implements Parcelable {
        private String path;
        private String mounted;
        private String description;
        private boolean removable;

        public String getPath() {
            return path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public String getMounted() {
            return mounted;
        }

        public void setMounted(String mounted) {
            this.mounted = mounted;
        }

        public boolean isRemovable() {
            return removable;
        }

        public void setRemovable(boolean removable) {
            this.removable = removable;
        }

        public String getDescription() {
            return description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeString(this.path);
            dest.writeString(this.mounted);
            dest.writeString(this.description);
            dest.writeByte(removable ? (byte) 1 : (byte) 0);

        }

        public StorageBean() {
        }

        protected StorageBean(Parcel in) {
            this.path = in.readString();
            this.mounted = in.readString();
            this.description = in.readString();
            this.removable = in.readByte() != 0;

        }

        public static final Creator<StorageBean> CREATOR = new Creator<StorageBean>() {
            @Override
            public StorageBean createFromParcel(Parcel source) {
                return new StorageBean(source);
            }

            @Override
            public StorageBean[] newArray(int size) {
                return new StorageBean[size];
            }
        };
    }
}
