package com.cv.media.lib.common_utils.utils;

import org.apache.commons.lang3.RandomUtils;

public class RandUtils {
    /**
     drand48(产生一个正的浮点型随机数)
     erand48(产生一个正的浮点型随机数)
     initstate(建立随机数状态数组)
     jrand48(产生一个长整型数随机数)
     lcong48(设置48位运算的随机数种子)
     lrand48(产生一个正的长整型随机数)
     mrand48(产生一个长整型随机数)
     nrand48(产生一个正的长整型随机数)
     rand(产生随机数)
     random(产生随机数)
     seed48(设置48位运算的随机数种子)
     setstate(建立随机数状态数组)
     srand(设置随机数种子)
     srand48(设置48位运算的随机数种子)
     srandom(设置随机数种子)
     */
    private static int lrand48(){
        //todo 从随机数的角度，整形长度已经够了
        return RandomUtils.nextInt(0, Integer.MAX_VALUE);
    }

    private static byte[] fixedByteArray(byte[] original, int fixedLen){
        byte[] ret = original;
        if(original.length % fixedLen != 0){
            int newLen = original.length + (fixedLen-original.length % fixedLen);
            ret = new byte[newLen];
            System.arraycopy(original, 0 , ret, 0, original.length);
            byte padding = (byte)((newLen - original.length) & 0xFF);
            for (int i=original.length; i<newLen; i++){
                ret[i] = padding;
            }
        }
        return ret;
    }

    /**
     * generate String, minLength:6 maxLength:seed+6
     * @param seed
     * @return
     */
    public static String genarateRandomString(int seed) {
        int randNumLess30 = lrand48() % seed;
        return new String(genarateRandomData(randNumLess30 + 6));
    }

    private static byte[] genarateRandomData(int len) {
        int _nIndex_v3 = 0;
        byte[] pDataBytes = new byte[len];
        int v8;
        while (_nIndex_v3 < len) {
            if (RandUtils.lrand48() % 3 > 0) {
                if ((RandUtils.lrand48() & 1) > 0) {
                    int v11 = RandUtils.lrand48();
                    int v12 = v11 % 10;
                    //pData = (char *)(v11 / 10);
                    v8 = v12 + 48;
                } else {
                    int v9 = RandUtils.lrand48();
                    int v10 = v9 % 26;
                    //pData = (char *)(v9 / 26);
                    v8 = v10 + 65;
                }
            } else {
                int v6 = RandUtils.lrand48();
                int v7 = v6 % 26;
                //pData = (byte *)(v6 / 26);
                v8 = v7 + 97;
            }
            pDataBytes[_nIndex_v3++] = (byte) v8;
        }
        return pDataBytes;
    }
    private static boolean matchSubMode(int seq, int subModeValue){
        int seqMode = seq % 32;
        int seqModeToSubMode = 1 << seqMode;
        int matchValue = seqModeToSubMode & subModeValue;
        if(matchValue != 0){
            return true;
        }
        return false;

    }
}
