package com.cv.media.lib.common_utils.utils;

import android.app.Dialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Typeface;
import android.util.Pair;
import android.util.TypedValue;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import android.widget.TextView;

import androidx.annotation.DimenRes;

import com.cv.media.lib.common_utils.callback.ICallBack;

/**
 * Created by elegant.wang on 2016/6/29.
 */
public class UiUtils {
    public static final String FONT_Aileron = "Roboto-Regular.ttf";

    public static void hideInput(Context context, View view) {
        InputMethodManager inputMethodManager = (InputMethodManager) context.getSystemService(Context.INPUT_METHOD_SERVICE);
        inputMethodManager.hideSoftInputFromWindow(view.getWindowToken(), 0);
    }

    public static void showInput(Context context, View view) {
        InputMethodManager inputMethodManager = (InputMethodManager) context.getSystemService(Context.INPUT_METHOD_SERVICE);
        inputMethodManager.showSoftInput(view, 0);
    }

    public static boolean blockViewKey(View v) {
        if (v.hasOnClickListeners()) {
            return false;
        }
        v.setOnKeyListener(new View.OnKeyListener() {
            @Override
            public boolean onKey(View v, int keyCode, KeyEvent event) {
                return true;
            }
        });
        return true;
    }

    public static void unBlockViewKey(View v) {
        v.setOnKeyListener(null);
    }


    public static void blockDialogKey(Dialog dialog) {
        dialog.setOnKeyListener(new DialogInterface.OnKeyListener() {
            @Override
            public boolean onKey(DialogInterface dialog, int keyCode, KeyEvent event) {
                return true;
            }
        });
    }

    public static void unBlockDialogKey(Dialog dialog) {
        dialog.setOnKeyListener(new DialogInterface.OnKeyListener() {
            @Override
            public boolean onKey(DialogInterface dialog, int keyCode, KeyEvent event) {
                return false;
            }
        });
    }

    public static ProgressDialog getHorizontalProgressDialog(Context context) {
        ProgressDialog dialog = new ProgressDialog(context);
        dialog.setMax(100);
        dialog.setProgressStyle(ProgressDialog.STYLE_HORIZONTAL);
        return dialog;
    }

    public static int getDimensionPixelSize(Context context, @DimenRes int dimenRes) {
        return context.getResources().getDimensionPixelSize(dimenRes);
    }

    public static int getPixel(Context context, int dp) {
        return (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, dp, context.getResources().getDisplayMetrics());
    }

    public static int getPixelF(Context context, float dp) {
        return (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, dp, context.getResources().getDisplayMetrics());
    }

    public static int getViewNextFocusId(View view, int direction) {
        switch (direction) {
            case View.FOCUS_LEFT:
                return view.getNextFocusLeftId();
            case View.FOCUS_UP:
                return view.getNextFocusUpId();
            case View.FOCUS_RIGHT:
                return view.getNextFocusRightId();
            case View.FOCUS_DOWN:
                return view.getNextFocusDownId();
            default:
                return View.NO_ID;
        }
    }

    public static Dialog setDialogAlpha(Dialog dialog, float alpha) {
        Window window = dialog.getWindow();
        WindowManager.LayoutParams lp = window.getAttributes();
        lp.alpha = alpha;
        window.setAttributes(lp);
        return dialog;
    }

    public static void setFontTypeface(Context context, String fontFileName, TextView... textViews) {
        if (textViews == null || textViews.length <= 0) return;
        Typeface typeface = Typeface.createFromAsset(context.getAssets(), "fonts/" + fontFileName);
        if (typeface == null) return;
        for (TextView textView : textViews) {
            if (textView == null) continue;
            textView.setTypeface(typeface);
        }
    }

    public static void traversalView(ViewGroup vp, ICallBack<View> cb) {
        for (int i = 0; i < vp.getChildCount(); i++) {
            View child = vp.getChildAt(i);
            if (cb != null) cb.call(child);
            if (child instanceof ViewGroup) traversalView((ViewGroup) child, cb);
        }
    }

    public static void traversalViewWithIndex(ViewGroup vp, ICallBack<Pair<View, Integer>> cb) {
        for (int i = 0; i < vp.getChildCount(); i++) {
            View child = vp.getChildAt(i);
            if (cb != null) cb.call(new Pair<>(child, i));
            if (child instanceof ViewGroup) traversalViewWithIndex((ViewGroup) child, cb);
        }
    }
}
