package com.cv.media.lib.common_utils.async;

import com.cv.media.lib.common_utils.callback.IAction;

import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

/**
 * 使用线程池的工具接口
 *
 * @Author Damon
 */
public class ThreadUtils {
    private final static Executor executors = ThreadPoolImpl.newInstance();

    public static void execute(Runnable runnable) {
        executors.execute(runnable);
    }

    public static void casLock(AtomicBoolean atomicBoolean, Runnable runnable) {
      while (true) {
          if (atomicBoolean.compareAndSet(false , true)) {
              runnable.run();
            atomicBoolean.set(false);
            break;
          }
      }
    }

    public static <T> T casLock(AtomicBoolean atomicBoolean, IAction<T> runnable) {
        T obj;
        while (true) {
            if (atomicBoolean.compareAndSet(false , true)) {
                obj = runnable.get();
                atomicBoolean.set(false);
                break;
            }
        }
        return obj;
    }

    public static void waitUntil(IAction<Boolean> action, long timeoutMs) {
        AtomicLong timeOutStamp = new AtomicLong(System.currentTimeMillis() + timeoutMs);
        ThreadUtils.execute(() -> {
            boolean ref;
            do {
                ref = action.get();
            } while (!ref);
            timeOutStamp.set(0);
        });

        while (true) {
            if (System.currentTimeMillis() >= timeOutStamp.get()) break;
        }

    }
}
