package com.cv.media.lib.common_utils.utils.storage;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipUtils {
    /**
     * 将多个压缩文件为一个zip文件
     *
     * @param zipFilePath 压缩后存放的路径
     * @param fileList    要压缩的文件集合
     */
    public static void mutileFileToGzip(String zipFilePath, List<String> fileList) {
        File file = new File(zipFilePath);
        if (file.exists()) {
            file.delete();
        }
        try {
            byte[] buffer = new byte[1024];
            FileOutputStream fos = new FileOutputStream(zipFilePath);
            ZipOutputStream zos = new ZipOutputStream(fos);
            ArrayList<File> files = new ArrayList<File>();
            for (String fileName : fileList) {
                files.add(new File(fileName));
            }
            for (int i = 0; i < files.size(); i++) {
                FileInputStream fis = new FileInputStream(files.get(i));
                zos.putNextEntry(new ZipEntry(files.get(i).getName()));
                int length;
                while ((length = fis.read(buffer)) > 0) {
                    zos.write(buffer, 0, length);
                }
                zos.closeEntry();
                fis.close();
            }
            zos.close();
        } catch (IOException ioe) {
        }
    }

    public static File mutileFilesToGzip(String zipFilePath, List<File> files) {
        File file = new File(zipFilePath);
        if (file.exists()) {
            file.delete();
        }
        FileOutputStream fos = null;
        ZipOutputStream zos = null;
        try {
            byte[] buffer = new byte[1024];
            fos = new FileOutputStream(zipFilePath);
            zos = new ZipOutputStream(fos);
            for (int i = 0; i < files.size(); i++) {
                FileInputStream fis = new FileInputStream(files.get(i));
                zos.putNextEntry(new ZipEntry(files.get(i).getName()));
                int length;
                while ((length = fis.read(buffer)) > 0) {
                    zos.write(buffer, 0, length);
                }
                zos.closeEntry();
                fis.close();
            }
            zos.close();
            fos.close();
            return file;
        } catch (IOException ioe) {
            ioe.printStackTrace();
        } finally {
            try {
                for (File f : files) {
                    f.delete();
                }
                if (zos != null) {
                    zos.close();
                }
                if (fos != null) {
                    fos.close();
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }

        return null;
    }

}