package com.cv.media.lib.common_utils.utils;

import java.util.LinkedList;
import java.util.List;

/**
 * Created by zhangyaoa on 2020/6/22.
 */
public class CollectUtil {
    private static final CollectUtil ourInstance = new CollectUtil();

    public static CollectUtil getInstance() {
        return ourInstance;
    }

    private CollectUtil() {
    }

    private static final int MAX_SIZE = 100;

    private Boolean stopCollect = false;

    public void setStopCollect(Boolean stopCollect) {
        this.stopCollect = stopCollect;
    }

    private LinkedList<Throwable> exceptions = new LinkedList<>();
    private LinkedList<Logs> myLogs = new LinkedList<>();
    private LinkedList<String> imageLoadFailList = new LinkedList<>();

    public void addExceptions(Throwable e) {
        if (stopCollect) {
            return;
        }

        clearHalfOldLogs(exceptions);

        exceptions.add(e);
    }

    public void addMyLogs(String title, String content) {
        if (stopCollect) {
            return;
        }

        clearHalfOldLogs(myLogs);

        Logs log = new Logs();
        log.title = title;
        log.content = content;

        myLogs.add(log);
    }

    public void addImageLoadFailInfo(String message) {
        if (stopCollect) {
            return;
        }
        clearHalfOldLogs(imageLoadFailList);

        if (!imageLoadFailList.contains(message)) {
            imageLoadFailList.add(message);
        }
    }

    public List<Logs> getLogText() {
        for (Throwable e : exceptions) {
            Logs logs = new Logs();
            logs.title = "Exception : ";
            logs.content = e.toString();
            myLogs.add(logs);
        }

        for (String msg : imageLoadFailList) {
            Logs logs = new Logs();
            logs.title = "image load fail message : " + msg;
            myLogs.add(logs);
        }

        return myLogs;
    }

    public void clearLog() {
        exceptions.clear();
        myLogs.clear();
    }

    public void clearHalfOldLogs(LinkedList list) {
        if (list.size() == MAX_SIZE) {
            for (int x = 0; x < MAX_SIZE / 2; x++) {
                try {
                    list.removeFirst();
                } catch (Exception e) {
                    stopCollect = true;
                }
            }
        }
    }

    public class Logs {
        public String title;
        public String content;
    }
}
