package com.cv.media.lib.common_utils.ntp;

import java.util.Date;
import java.util.concurrent.TimeUnit;

import com.cv.media.lib.common_utils.async.ThreadsBox;

public class TrueTime {
    private static final String TAG = TrueTime.class.getSimpleName();
    private static TrueTime INSTANCE = new TrueTime();

    public static TrueTime getInstance() {
        return INSTANCE;
    }

    private SystemTimeProvider mSystem;
    private ServerTimeProvider mServer;
    private SntpTimeProvider mSntp;
    private WebTimeProvider mWeb;


    private TrueTime() {
        mSystem = new SystemTimeProvider();
        mServer = new ServerTimeProvider();
        mSntp = new SntpTimeProvider();
        mWeb = new WebTimeProvider();
        sync();
    }

    public Date now() {
        return new Date(currentTimeMillis());
    }

    public long currentTimeMillis() {
        if (mServer.wasInitialized()) return mServer.currentTimeMillis();
        if (mSystem.wasInitialized()) return mSystem.currentTimeMillis();
        if (mSntp.wasInitialized()) return mSntp.currentTimeMillis();
        if (mWeb.wasInitialized()) return mWeb.currentTimeMillis();
        return mSystem.currentTimeMillis();
    }

    public long trueTimeOrZero() {
        if (mSystem.wasInitialized()) return mSystem.currentTimeMillis();
        if (mSntp.wasInitialized()) return mSntp.currentTimeMillis();
        if (mServer.wasInitialized()) return mServer.currentTimeMillis();
        if (mWeb.wasInitialized()) return mWeb.currentTimeMillis();
        return 0;
    }

    public void sync() {
        ThreadsBox.getDefaultHandler().post(new Runnable() {
            @Override
            public void run() {
                ntpSync();
                webSync();
            }
        });
    }

    public void ntpSync() {
        if (mSntp.requestNtpTime()) {
            mSystem.setSystemTime(mSntp.currentTimeMillis());
        } else {
            ThreadsBox.getDefaultHandler().postDelayed(new Runnable() {
                @Override
                public void run() {
                    ntpSync();
                }
            }, TimeUnit.MINUTES.toMillis(5));
        }
    }

    public void webSync() {
       // LogUtils.printfThreadInfo(TAG, "TrueTimeInit_webSync");
        if (mWeb.requestWebTime()) {
            // mSystem.setSystemTime(mWeb.currentTimeMillis());
        } else {
            ThreadsBox.getDefaultHandler().postDelayed(new Runnable() {
                @Override
                public void run() {
                    webSync();
                }
            }, TimeUnit.MINUTES.toMillis(5));
        }
    }


    public void updateServerTime(long serverTime) {
        mServer.setServerTime(serverTime);
        mSystem.setSystemTime(serverTime);
    }
}
