package com.cv.media.lib.common_utils.laucher;

import android.app.Activity;
import android.app.Application;
import android.content.Intent;
import android.os.Bundle;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.cv.media.lib.common_utils.utils.Singleton;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public final class DataFromLaunch {
    private static Singleton<DataFromLaunch> singleton = new Singleton<DataFromLaunch>() {
        @Override
        protected DataFromLaunch create() {
            return new DataFromLaunch();
        }
    };

    private final HashMap<String, String> kv = new HashMap<>();

    private DataFromLaunch() {
    }

    public static DataFromLaunch getInstance() {
        return singleton.get();
    }

    public synchronized void reg(String key) {
        kv.put(key, null);
    }

    public synchronized String get(String key) {
        return kv.get(key);
    }

    public void init(Application application) {
        application.registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks() {
            @Override
            public void onActivityCreated(@NonNull Activity activity, @Nullable Bundle savedInstanceState) {
                getData(activity);
            }

            @Override
            public synchronized void onActivityStarted(@NonNull Activity activity) {
                getData(activity);
            }

            @Override
            public void onActivityResumed(@NonNull Activity activity) {

            }

            @Override
            public void onActivityPaused(@NonNull Activity activity) {

            }

            @Override
            public void onActivityStopped(@NonNull Activity activity) {

            }

            @Override
            public void onActivitySaveInstanceState(@NonNull Activity activity, @NonNull Bundle outState) {

            }

            @Override
            public void onActivityDestroyed(@NonNull Activity activity) {

            }
        });
    }

    private void getData(@NonNull Activity activity) {
        Intent intent = activity.getIntent();
        if (intent != null) {
            Set<String> keySet = new HashSet<>(kv.keySet());
            for (String k : keySet) {
                String v = intent.getStringExtra(k);
                if (v != null) kv.put(k, v);
            }
        }
    }
}
