package com.cv.media.lib.common_utils.utils;

import android.content.Context;
import android.os.Build;
import android.os.SystemProperties;
import android.util.Log;


/**
 * Created by elegant.wang on 2016/8/22.
 */
public class EnvUtils {
    private static final String TAG = EnvUtils.class.getSimpleName();
    public static final String MFC_PROP_PLAY_STATE = "net.change.mfc.c.ps";
    public static final String MFC_PROP_TV_APP_INSTALL_FLAG = "net.change.mfc.c.tv.f";

    public static String getLocaleString(Context context) {
        //todo MyApplication.getInstance()不可能是null吧？
        if (context != null) {
            //todo locale.toString 会包含国家编码，所以这里只使用语言编码
            return context.getResources().getConfiguration().locale.getLanguage();
        } else {
            return "";
        }
    }

    public static String getSystemProperty(String key) {
        return SystemProperties.get(key, "");
    }

    public static String getSystemProperty(String key, String def) {
        return SystemProperties.get(key, def);
    }

    /**
     * key can't exceeds 32 characters
     * value can't exceeds 92 characters
     */
    public static void setSystemProperty(String key, String value) {
        try {
            SystemProperties.set(key, value);
        } catch (Throwable throwable) {
            throwable.printStackTrace();
            Log.e(TAG,"fail to set system property");
        }
    }

    public static void setPlaying(boolean playState) {
        if (playState) {
            setSystemProperty(MFC_PROP_PLAY_STATE, "1");
        } else {
            setSystemProperty(MFC_PROP_PLAY_STATE, "0");
        }
    }

    public static boolean isPlaying() {
        return getSystemProperty(MFC_PROP_PLAY_STATE, "0").equals("1");
    }

    public static void setTvAppInstalled(boolean installed) {
        setSystemProperty(MFC_PROP_TV_APP_INSTALL_FLAG, installed ? "1" : "0");
    }

    public static boolean isTvAppInstalled() {
        return getSystemProperty(MFC_PROP_TV_APP_INSTALL_FLAG, "0").equals("1");
    }

    public static boolean hasGreenScreenBug() {
        try {
            return Build.MANUFACTURER.toLowerCase().equals("rockchip") || Build.HARDWARE.equals("rk30board") || Build.PRODUCT.equals("rk322x_box");
        } catch (Throwable t) {
            return false;
        }
    }
}
