package com.cv.media.lib.common_utils.crypto;


import android.util.Log;

import com.ijiami.AlgorithmType;
import com.ijiami.JMEncryptBox;
import com.ijiami.StatusInfo;


/**
 * Created by elegant.wang on 2016/8/6.
 */
public class SecurityUtil {
    private static final String TAG = SecurityUtil.class.getSimpleName();
    private static final SecurityUtil sInstance = new SecurityUtil();

    private SecurityUtil() {
    }

    public static SecurityUtil getInstance() {
        return sInstance;
    }

    public void init(String IJM_KEY,
                     String UP_KEY_CIPHER,
                     String DB_KEY_CIPHER,
                     String DATA_KEY_CIPHER,
                     String API_SERVER_KEY_CIPHER,
                     String API_SERVER_KEY2_CIPHER) {
        StatusInfo statusInfo = JMEncryptBox.setLicenseKey(IJM_KEY);
        if (statusInfo.getStatusCode() != 1) {
            //String text = "绑定失败：" + statusInfo.getStatusDescribe() + ",statusCode:" + statusInfo.getStatusCode();
            // Timber.e(text);
            throw new RuntimeException("bind fail");
        } else {
            //String text = "绑定成功：" + statusInfo.getStatusDescribe() + ",statusCode:" + statusInfo.getStatusCode();
            // Timber.d(text);
        }

        try {
            this.UP_KEY = decryptString(UP_KEY_CIPHER);
            this.DB_KEY = decryptString(DB_KEY_CIPHER);
            this.DATA_KEY = decryptString(DATA_KEY_CIPHER);
            this.API_SERVER_KEY = decryptString(API_SERVER_KEY_CIPHER);
            this.API_SERVER_KEY2 = decryptString(API_SERVER_KEY2_CIPHER);
        } catch (Exception e) {
            Log.e(TAG, "init key error");
        }
    }

    private static int selectedAlgorithmType = AlgorithmType.AES;

    private String UP_KEY;
    private String DB_KEY;
    private String DATA_KEY;
    private String API_SERVER_KEY;
    private String API_SERVER_KEY2;

    public String encryptString(String plain) throws Exception {
        String cipher = JMEncryptBox.encryptToBase64(plain, selectedAlgorithmType);
        return cipher;
    }

    public String decryptString(String cipher) throws Exception {
        String plain = JMEncryptBox.decryptFromBase64(cipher, selectedAlgorithmType).getText();
        return plain;
    }

    public String sign(String message) {
        return Utils.sha1(message);
    }

    public String getUpKey() {
        return UP_KEY;
    }

    public String getDBKey() {
        return DB_KEY;
    }

    public String getDataKey() {
        return DATA_KEY;
    }

    public String getApiServerKey() {
        return API_SERVER_KEY;
    }

    public String getApiServerKey2() {
        return API_SERVER_KEY2;
    }
}
