package com.cv.media.lib.common_utils.webview;

import android.content.Context;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;

import com.cv.media.lib.common_utils.callback.IAction;
import com.cv.media.lib.common_utils.callback.ICallBack;


/**
 * WebView
 * 职责: 在某些设备WebView会初始化失败, 当出现这样的情况需要做保护
 *
 * @author Damon
 */
public class WebViewEx extends ViewGroup {
    WebView mWebView;
    View mInvalidView;

    private CallBack mCallBack;

    public WebViewEx(Context context) {
        super(context);
    }

    public WebViewEx(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public void setCallBack(CallBack mCallBack) {
        this.mCallBack = mCallBack;
    }

    public void init(final Class webViewClz, final IAction<Integer> layoutWhenInvalid, final ICallBack<WebView> webViewICallBack) {
        getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener() {
            @Override
            public boolean onPreDraw() {
                getViewTreeObserver().removeOnPreDrawListener(this);
                post(new Runnable() {
                    @Override
                    public void run() {
                        initInternal(webViewClz, layoutWhenInvalid, webViewICallBack);
                    }
                });
                return true;
            }
        });

    }

    void initInternal(final Class WebViewClz, final IAction<Integer> layoutWhenInvalid, final ICallBack<WebView> webViewICallBack){
        try {
            if (WebViewClz != null && WebView.class.isAssignableFrom(WebViewClz)) {
                mWebView = (WebView) WebViewClz.getConstructor(Context.class).newInstance(getContext());
            } else {
                mWebView = new WebView(getContext());
            }

            mWebView.setWebViewClient(new WebViewClient());
            WebSettings webSettings = mWebView.getSettings();
            webSettings.setJavaScriptEnabled(true);
            webSettings.setSupportZoom(false);
            webSettings.setBuiltInZoomControls(false);
            webSettings.setTextZoom(100);
            webSettings.setCacheMode(WebSettings.LOAD_NO_CACHE);
            mWebView.setFocusable(true);
            addView(mWebView, new LayoutParams(LayoutParams.MATCH_PARENT, LayoutParams.MATCH_PARENT));
            webViewICallBack.call(mWebView);
        } catch (Exception e) {
            if (e.getMessage() != null && e.getMessage().contains("MissingWebViewPackageException")) {
                mInvalidView = LayoutInflater.from(getContext()).inflate(layoutWhenInvalid.get(), WebViewEx.this, false);
                addView(mInvalidView, new LayoutParams(LayoutParams.MATCH_PARENT, LayoutParams.MATCH_PARENT));
            }
        }
    }


    public void loadUrl(String url) {
        if (mWebView != null) {
            mWebView.loadUrl(url);
        }
    }


    @Override
    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        View child = getChildAt(0);
        if (child != null) {
            child.layout(0, 0, r - l, b - t);
        }
    }

    @Override
    public boolean dispatchKeyEventPreIme(KeyEvent event) {
        if (mWebView != null && mWebView.isFocused()) {
            int keyCode = event.getKeyCode();
            if (keyCode == KeyEvent.KEYCODE_BACK) {
                if (mWebView.canGoBack()) {
                    if (event.getAction() == KeyEvent.ACTION_UP) mWebView.goBack();
                    return true;
                } else {
                    if (event.getAction() == KeyEvent.ACTION_UP && mCallBack != null) {
                        return mCallBack.handleBackEvent();
                    }
                }
            }
        }
        return super.dispatchKeyEventPreIme(event);
    }

    public interface CallBack {
        boolean handleBackEvent();
    }
}
