package com.cv.media.lib.common_utils.ntp;

import android.os.SystemClock;

import java.util.Date;

public class ServerTimeProvider implements TimeProvider {
    public static long SERVER_TIME_OFFSET_DEF = 1000;// 默认为1s
    private boolean initialized;
    private long serverTime;
    private long lastUpdateTicks;

    public void setServerTime(long serverTime) {
        this.serverTime = serverTime + SERVER_TIME_OFFSET_DEF;
        lastUpdateTicks = SystemClock.elapsedRealtime();
        initialized = true;
    }


    @Override
    public Date now() {
        return new Date(serverTime + SystemClock.elapsedRealtime() - lastUpdateTicks);
    }

    @Override
    public long currentTimeMillis() {
        return serverTime + +SystemClock.elapsedRealtime() - lastUpdateTicks;
    }

    @Override
    public boolean wasInitialized() {
        return initialized;
    }
}
