package com.cv.media.lib.hardware.device;

import android.os.Build;

import com.cv.media.lib.common_utils.utils.SystemPropertiesProxy;
import com.google.gson.annotations.Expose;

import static com.cv.media.lib.common_utils.provider.ContextProvider.getContext;

/**
 * Created by elegant.wang on 2018/3/2.
 */

public class DeviceInfo {
    private String androidVersion;
    private int sdk;
    private String productBrand;
    private String productModel;
    private String productBoard;
    private String productDevice;
    private String productManufacturer;
    private String buildFingerprint;
    private String buildDisplay;
    private String buildType;
    private String buildUser;
    private String buildHost;
    private long buildDateUtc;
    private String buildTags;
    private String buildId;
    private String hardware; //ro.hardware
    private String bootloader;
    private String firmware;
    private String platform;

    private String ethernetMac;
    private String wifiMac;
    private String bluetoothMac;
    private String cpuHardware;
    private String cpuSerial;
    private long ramSize;
    private long romSize;
    @Expose
    private String cpuinfo;

    private String imei;
    private String androidId;

    public DeviceInfo() {
        androidVersion = Build.VERSION.RELEASE;
        sdk = Build.VERSION.SDK_INT;
        productBrand = Build.BRAND;
        productModel = Build.MODEL;
        productBoard = Build.BOARD;
        productDevice = Build.DEVICE;
        productManufacturer = Build.MANUFACTURER;
        buildFingerprint = Build.FINGERPRINT;
        buildDisplay = Build.DISPLAY;
        buildType = Build.TYPE;
        buildUser = Build.USER;
        buildHost = Build.HOST;
        buildDateUtc = Build.TIME;
        buildTags = Build.TAGS;
        buildId = Build.ID;
        hardware = Build.HARDWARE;
        bootloader = Build.BOOTLOADER;
        bootloader = Build.BOOTLOADER;
        try {
            firmware = SystemPropertiesProxy.get(getContext(), "ro.product.firmware");
        } catch (Exception e) {
            firmware = "";
        }

        try {
            platform = SystemPropertiesProxy.get(getContext(), "ro.product.platform");
        } catch (Exception e) {
            platform = "";
        }
    }

    public String getFirmware() {
        return firmware;
    }

    public void setFirmware(String firmware) {
        this.firmware = firmware;
    }

    public String getPlatform() {
        return platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public String getAndroidVersion() {
        return androidVersion;
    }

    public void setAndroidVersion(String androidVersion) {
        this.androidVersion = androidVersion;
    }

    public int getSdk() {
        return sdk;
    }

    public void setSdk(int sdk) {
        this.sdk = sdk;
    }

    public String getProductBrand() {
        return productBrand;
    }

    public void setProductBrand(String productBrand) {
        this.productBrand = productBrand;
    }

    public String getProductModel() {
        return productModel;
    }

    public void setProductModel(String productModel) {
        this.productModel = productModel;
    }

    public String getProductBoard() {
        return productBoard;
    }

    public void setProductBoard(String productBoard) {
        this.productBoard = productBoard;
    }

    public String getProductDevice() {
        return productDevice;
    }

    public void setProductDevice(String productDevice) {
        this.productDevice = productDevice;
    }

    public String getProductManufacturer() {
        return productManufacturer;
    }

    public void setProductManufacturer(String productManufacturer) {
        this.productManufacturer = productManufacturer;
    }

    public String getBuildFingerprint() {
        return buildFingerprint;
    }

    public void setBuildFingerprint(String buildFingerprint) {
        this.buildFingerprint = buildFingerprint;
    }

    public String getBuildDisplay() {
        return buildDisplay;
    }

    public void setBuildDisplay(String buildDisplay) {
        this.buildDisplay = buildDisplay;
    }

    public String getBuildType() {
        return buildType;
    }

    public void setBuildType(String buildType) {
        this.buildType = buildType;
    }

    public String getBuildUser() {
        return buildUser;
    }

    public void setBuildUser(String buildUser) {
        this.buildUser = buildUser;
    }

    public String getBuildHost() {
        return buildHost;
    }

    public void setBuildHost(String buildHost) {
        this.buildHost = buildHost;
    }

    public long getBuildDateUtc() {
        return buildDateUtc;
    }

    public void setBuildDateUtc(long buildDateUtc) {
        this.buildDateUtc = buildDateUtc;
    }

    public String getBuildTags() {
        return buildTags;
    }

    public void setBuildTags(String buildTags) {
        this.buildTags = buildTags;
    }

    public String getBuildId() {
        return buildId;
    }

    public void setBuildId(String buildId) {
        this.buildId = buildId;
    }

    public String getHardware() {
        return hardware;
    }

    public void setHardware(String hardware) {
        this.hardware = hardware;
    }

    public String getBootloader() {
        return bootloader;
    }

    public void setBootloader(String bootloader) {
        this.bootloader = bootloader;
    }

    public String getEthernetMac() {
        return ethernetMac;
    }

    public void setEthernetMac(String ethernetMac) {
        this.ethernetMac = ethernetMac;
    }

    public String getWifiMac() {
        return wifiMac;
    }

    public void setWifiMac(String wifiMac) {
        this.wifiMac = wifiMac;
    }

    public String getBluetoothMac() {
        return bluetoothMac;
    }

    public void setBluetoothMac(String bluetoothMac) {
        this.bluetoothMac = bluetoothMac;
    }

    public String getCpuHardware() {
        return cpuHardware;
    }

    public void setCpuHardware(String cpuHardware) {
        this.cpuHardware = cpuHardware;
    }

    public String getCpuSerial() {
        return cpuSerial;
    }

    public void setCpuSerial(String cpuSerial) {
        this.cpuSerial = cpuSerial;
    }

    public long getRamSize() {
        return ramSize;
    }

    public void setRamSize(long ramSize) {
        this.ramSize = ramSize;
    }

    public long getRomSize() {
        return romSize;
    }

    public void setRomSize(long romSize) {
        this.romSize = romSize;
    }

    public String getCpuinfo() {
        return cpuinfo;
    }

    public void setCpuinfo(String cpuinfo) {
        this.cpuinfo = cpuinfo;
    }

    public String getImei() {
        return imei;
    }

    public void setImei(String imei) {
        this.imei = imei;
    }

    public String getAndroidId() {
        return androidId;
    }

    public void setAndroidId(String androidId) {
        this.androidId = androidId;
    }
}
